/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.command.parser;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.caption.CaptionVariable;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.caption.StandardCaptionKeys;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.exception.parsing.ParserException;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.EnumParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@DefaultQualifier(value=NonNull.class)
public final class PromotionParser
implements ArgumentParser<CommandSender, PieceType>,
BlockingSuggestionProvider.Strings<CommandSender> {
    public static final Set<PieceType> VALID_PROMOTIONS = Set.of(PieceType.BISHOP, PieceType.KNIGHT, PieceType.QUEEN, PieceType.ROOK);
    private static final List<String> SUGGESTIONS = VALID_PROMOTIONS.stream().map(Enum::name).toList();

    public static ParserDescriptor<CommandSender, PieceType> promotionParser() {
        return ParserDescriptor.of(new PromotionParser(), PieceType.class);
    }

    @Override
    public ArgumentParseResult<PieceType> parse(CommandContext<CommandSender> commandContext, CommandInput commandInput) {
        String input = commandInput.readString();
        for (PieceType value : VALID_PROMOTIONS) {
            if (!value.name().equalsIgnoreCase(input)) continue;
            return ArgumentParseResult.success(value);
        }
        return ArgumentParseResult.failure(new ParseException(input, commandContext));
    }

    public List<String> stringSuggestions(CommandContext<CommandSender> commandContext, CommandInput commandInput) {
        return SUGGESTIONS;
    }

    public static final class ParseException
    extends ParserException {
        private static final long serialVersionUID = 2261721931860121220L;

        public ParseException(String input, CommandContext<?> context) {
            super(EnumParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_ENUM, CaptionVariable.of("input", input), CaptionVariable.of("acceptableValues", ParseException.acceptableValues()));
        }

        private static String acceptableValues() {
            return VALID_PROMOTIONS.stream().map(e -> e.toString().toLowerCase()).collect(Collectors.joining(", "));
        }
    }
}

