/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.command.parser;

import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.command.Commands;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.chesscraft.util.ComponentRuntimeException;

@DefaultQualifier(value=NonNull.class)
public final class ChessBoardParser
implements ArgumentParser<CommandSender, ChessBoard>,
BlockingSuggestionProvider.Strings<CommandSender> {
    private final SuggestionsMode suggestions;

    private ChessBoardParser(SuggestionsMode suggestions) {
        this.suggestions = suggestions;
    }

    public static ParserDescriptor<CommandSender, ChessBoard> chessBoardParser() {
        return ChessBoardParser.chessBoardParser(SuggestionsMode.ALL);
    }

    public static ParserDescriptor<CommandSender, ChessBoard> chessBoardParser(SuggestionsMode suggestionsMode) {
        return ParserDescriptor.of(new ChessBoardParser(suggestionsMode), ChessBoard.class);
    }

    @Override
    public ArgumentParseResult<ChessBoard> parse(CommandContext<CommandSender> commandContext, CommandInput commandInput) {
        ChessCraft plugin = commandContext.get(Commands.PLUGIN);
        String input = commandInput.readString();
        ChessBoard g = plugin.boardManager().board(input);
        if (g != null) {
            return ArgumentParseResult.success(g);
        }
        return ArgumentParseResult.failure(ComponentRuntimeException.withMessage((ComponentLike)plugin.config().messages().noSuchBoard(input)));
    }

    public List<String> stringSuggestions(CommandContext<CommandSender> commandContext, CommandInput input) {
        ChessCraft plugin = commandContext.get(Commands.PLUGIN);
        return plugin.boardManager().boards().stream().filter(board -> switch (this.suggestions.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> true;
            case 0 -> {
                if (board.autoCpuGame().cpuGamesOnly()) {
                    yield false;
                }
                if (!board.hasGame() || board.game().cpuVsCpu() && board.autoCpuGame().enabled) {
                    yield true;
                }
                yield false;
            }
            case 1 -> board.hasGame();
        }).map(ChessBoard::name).toList();
    }

    public static enum SuggestionsMode {
        PLAYABLE_ONLY,
        OCCUPIED_ONLY,
        ALL;

    }
}

