/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.command;

import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.CommandManager;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.DefaultValue;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.TypedCommandComponent;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.help.HelpHandler;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.help.result.CommandEntry;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.minecraft.extras.AudienceProvider;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.minecraft.extras.MinecraftHelp;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.StringParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@DefaultQualifier(value=NonNull.class)
public final class HelpCommand {
    private final CommandManager<CommandSender> manager;
    private final MinecraftHelp<CommandSender> minecraftHelp;
    private final TypedCommandComponent<CommandSender, String> helpQueryArgument;

    HelpCommand(CommandManager<CommandSender> mgr) {
        this.manager = mgr;
        this.minecraftHelp = HelpCommand.createMinecraftHelp(mgr);
        this.helpQueryArgument = HelpCommand.createHelpQueryArgument(mgr);
    }

    public void register() {
        this.manager.command(this.manager.commandBuilder("chess", new String[0]).literal("help", new String[0]).argument(this.helpQueryArgument).permission("chesscraft.command.help").handler(this::executeHelp));
    }

    private void executeHelp(CommandContext<CommandSender> context) {
        this.minecraftHelp.queryCommands((String)context.get(this.helpQueryArgument), context.sender());
    }

    private static TypedCommandComponent<CommandSender, String> createHelpQueryArgument(CommandManager<CommandSender> mgr) {
        HelpHandler<CommandSender> commandHelpHandler = mgr.createHelpHandler();
        BlockingSuggestionProvider.Strings suggestions = (context, input) -> commandHelpHandler.queryRootIndex((CommandSender)context.sender()).entries().stream().map(CommandEntry::syntax).toList();
        return TypedCommandComponent.builder().name("query").parser(StringParser.greedyStringParser()).suggestionProvider(suggestions).optional().defaultValue(DefaultValue.constant("")).build();
    }

    private static MinecraftHelp<CommandSender> createMinecraftHelp(CommandManager<CommandSender> mgr) {
        return MinecraftHelp.builder().commandManager(mgr).audienceProvider(AudienceProvider.nativeAudience()).commandPrefix("/chess help").colors(MinecraftHelp.helpColors(TextColor.color((int)7877121), (TextColor)NamedTextColor.WHITE, TextColor.color((int)12088129), (TextColor)NamedTextColor.GRAY, (TextColor)NamedTextColor.DARK_GRAY)).messageProvider(MinecraftHelp.captionMessageProvider(mgr.captionRegistry(), ComponentCaptionFormatter.miniMessage())).build();
    }
}

