/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.command;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.BoardManager;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.command.CommandCompleted;
import xyz.jpenilla.chesscraft.command.HelpCommand;
import xyz.jpenilla.chesscraft.command.parser.ChessBoardParser;
import xyz.jpenilla.chesscraft.command.parser.PromotionParser;
import xyz.jpenilla.chesscraft.command.parser.TimeControlParser;
import xyz.jpenilla.chesscraft.config.Messages;
import xyz.jpenilla.chesscraft.data.CardinalDirection;
import xyz.jpenilla.chesscraft.data.PVPChallenge;
import xyz.jpenilla.chesscraft.data.PVPChallengeImpl;
import xyz.jpenilla.chesscraft.data.PVPChallengeResumeMatchImpl;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.Command;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.bukkit.data.SinglePlayerSelector;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.bukkit.internal.BukkitBrigadierMapper;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.bukkit.parser.MaterialParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.CommandComponent;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.DefaultValue;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.exception.CommandExecutionException;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.exception.handling.ExceptionHandler;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.execution.ExecutionCoordinator;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.key.CloudKey;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.paper.LegacyPaperCommandManager;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.flag.CommandFlag;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.flag.FlagContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.EnumParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.IntegerParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.StringParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.UUIDParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.suggestion.SuggestionProvider;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.TranslationBundle;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.bukkit.BukkitTranslationBundle;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.minecraft.extras.AudienceLocaleExtractor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.minecraft.extras.MinecraftExtrasTranslationBundle;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.range.Range;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.tuple.Pair;
import xyz.jpenilla.chesscraft.util.MatchExporter;
import xyz.jpenilla.chesscraft.util.Pagination;
import xyz.jpenilla.chesscraft.util.PaginationHelper;

public final class Commands {
    public static final CloudKey<ChessCraft> PLUGIN = CloudKey.cloudKey("chesscraft", ChessCraft.class);
    private final ChessCraft plugin;
    private final LegacyPaperCommandManager<CommandSender> mgr;
    private final BoardManager boardManager;
    private final PaginationHelper pagination;

    public Commands(ChessCraft plugin) {
        this.plugin = plugin;
        this.boardManager = plugin.boardManager();
        this.mgr = Commands.createCommandManager(plugin);
        this.pagination = new PaginationHelper(plugin);
    }

    public void register() {
        new HelpCommand(this.mgr).register();
        Command.Builder chess = this.mgr.commandBuilder("chess", new String[0]);
        this.mgr.command(chess.literal("version", new String[0]).permission("chesscraft.command.version").handler(this::version));
        this.mgr.command(chess.literal("boards", new String[0]).permission("chesscraft.command.boards").handler(this::boards));
        this.mgr.command(chess.literal("reload", new String[0]).permission("chesscraft.command.reload").handler(this::reload));
        this.mgr.command(chess.literal("create_board", new String[0]).required("name", StringParser.stringParser()).required("facing", EnumParser.enumParser(CardinalDirection.class)).optional("scale", IntegerParser.integerParser(1), DefaultValue.constant(1)).senderType(Player.class).permission("chesscraft.command.create_board").handler(this::createBoard));
        this.mgr.command(chess.literal("set_checkerboard", new String[0]).required("board", ChessBoardParser.chessBoardParser()).flag(this.mgr.flagBuilder("black").withComponent(MaterialParser.materialParser())).flag(this.mgr.flagBuilder("white").withComponent(MaterialParser.materialParser())).flag(this.mgr.flagBuilder("border").withComponent(MaterialParser.materialParser())).permission("chesscraft.command.set_checkerboard").handler(this::setCheckerboard));
        this.mgr.command(chess.literal("delete_board", new String[0]).required("board", ChessBoardParser.chessBoardParser()).permission("chesscraft.command.delete_board").handler(this::deleteBoard));
        this.mgr.command(chess.literal("challenge", new String[0]).literal("cpu", new String[0]).required("board", ChessBoardParser.chessBoardParser(ChessBoardParser.SuggestionsMode.PLAYABLE_ONLY)).required("color", EnumParser.enumParser(PieceColor.class)).argument(Commands.eloComponent("cpu_elo")).optional("time_control", TimeControlParser.timeControlParser()).senderType(Player.class).permission("chesscraft.command.challenge.cpu").handler(this::challengeCpu));
        this.mgr.command(chess.literal("challenge", new String[0]).literal("player", new String[0]).required("board", ChessBoardParser.chessBoardParser(ChessBoardParser.SuggestionsMode.PLAYABLE_ONLY)).required("player", SinglePlayerSelectorParser.singlePlayerSelectorParser()).required("color", EnumParser.enumParser(PieceColor.class)).optional("time_control", TimeControlParser.timeControlParser()).senderType(Player.class).permission("chesscraft.command.challenge.player").handler(this::challengePlayer));
        this.mgr.command(chess.literal("accept", new String[0]).senderType(Player.class).permission("chesscraft.command.accept").handler(this::accept));
        this.mgr.command(chess.literal("deny", new String[0]).senderType(Player.class).permission("chesscraft.command.deny").handler(this::deny));
        this.mgr.command(chess.literal("next_promotion", new String[0]).required("type", PromotionParser.promotionParser()).senderType(Player.class).permission("chesscraft.command.next_promotion").handler(this::nextPromotion));
        this.mgr.command(chess.literal("show_legal_moves", new String[0]).senderType(Player.class).permission("chesscraft.command.show_legal_moves").handler(this::showLegalMoves));
        this.mgr.command(chess.literal("forfeit", new String[0]).senderType(Player.class).permission("chesscraft.command.forfeit").handler(this::forfeit));
        this.mgr.command(chess.literal("reset_board", new String[0]).required("board", ChessBoardParser.chessBoardParser()).flag(CommandFlag.builder("clear")).permission("chesscraft.command.reset_board").handler(this::resetBoard));
        this.mgr.command(chess.literal("cpu_match", new String[0]).required("board", ChessBoardParser.chessBoardParser()).flag(this.mgr.flagBuilder("white_elo").withAliases("w").withComponent(Commands.eloComponent("elo"))).flag(this.mgr.flagBuilder("black_elo").withAliases("b").withComponent(Commands.eloComponent("elo"))).flag(this.mgr.flagBuilder("move_delay").withAliases("d").withComponent(IntegerParser.integerParser(0))).flag(this.mgr.flagBuilder("time_control").withAliases("t").withComponent(TimeControlParser.timeControlParser())).flag(this.mgr.flagBuilder("replace").withAliases("r")).permission("chesscraft.command.cpu_match").handler(this::cpuMatch));
        this.mgr.command(chess.literal("cancel_match", new String[0]).required("board", ChessBoardParser.chessBoardParser(ChessBoardParser.SuggestionsMode.OCCUPIED_ONLY)).permission("chesscraft.command.cancel_match").handler(this::cancelMatch));
        this.mgr.command(chess.literal("pause_match", new String[0]).senderType(Player.class).permission("chesscraft.command.pause_match").handler(this::pauseMatch));
        this.mgr.command(chess.literal("accept_pause", new String[0]).senderType(Player.class).permission("chesscraft.command.accept_pause").handler(this::acceptPause));
        this.mgr.command(chess.literal("resume_match", new String[0]).required("id", UUIDParser.uuidParser()).required("board", ChessBoardParser.chessBoardParser(ChessBoardParser.SuggestionsMode.PLAYABLE_ONLY)).senderType(Player.class).permission("chesscraft.command.resume_match").futureHandler(this::resumeMatch));
        Consumer<Command.Builder> withPage = builder -> {
            this.mgr.command((Command.Builder<CommandSender>)builder);
            this.mgr.command(builder.literal("page", new String[0]).required("page", IntegerParser.integerParser(1)));
        };
        Command.Builder pausedMatches = chess.literal("paused_matches", new String[0]).futureHandler(this::pausedMatches);
        withPage.accept(pausedMatches.permission("chesscraft.command.paused_matches.self"));
        withPage.accept(pausedMatches.permission("chesscraft.command.paused_matches.others").required("player", OfflinePlayerParser.offlinePlayerParser()));
        Command.Builder matchHistory = chess.literal("match_history", new String[0]).futureHandler(this::matchHistory);
        withPage.accept(matchHistory.permission("chesscraft.command.match_history.self"));
        withPage.accept(matchHistory.permission("chesscraft.command.match_history.others").required("player", OfflinePlayerParser.offlinePlayerParser()));
        this.mgr.command(chess.literal("export_match", new String[0]).required("id", UUIDParser.uuidParser()).permission("chesscraft.command.export_match").senderType(Player.class).futureHandler(this::exportMatch));
        this.mgr.command(chess.literal("leaderboard", new String[0]).permission("chesscraft.command.leaderboard").futureHandler(this::leaderboard));
    }

    private static CommandComponent.Builder<CommandSender, Integer> eloComponent(String name) {
        return CommandComponent.builder().valueType(Integer.class).name(name).parser(IntegerParser.integerParser(100, 4000)).suggestionProvider(SuggestionProvider.blockingStrings((ctx, input) -> {
            if (input.remainingInput().length() <= 1) {
                return List.of("800", "1200", "1400", "1600", "1800", "2000", "2200", "2400");
            }
            return IntegerParser.getSuggestions(Range.intRange(100, 4000), input);
        }));
    }

    private void version(CommandContext<CommandSender> ctx) {
        ctx.sender().sendRichMessage("<bold><black>Chess<white>Craft");
        ctx.sender().sendRichMessage("<gray><italic>  v" + this.plugin.getPluginMeta().getVersion());
    }

    private void boards(CommandContext<CommandSender> ctx) {
        CommandSender sender = ctx.sender();
        sender.sendMessage("Chess boards:");
        for (ChessBoard board : this.boardManager.boards()) {
            ctx.sender().sendMessage((ComponentLike)Component.text().content(board.name()).apply(builder -> {
                if (board.hasGame()) {
                    builder.append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY)).append(board.game().white().name().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)" vs ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC})).append(board.game().black().name().color((TextColor)NamedTextColor.DARK_GRAY));
                }
            }));
        }
    }

    private void reload(CommandContext<CommandSender> ctx) {
        ctx.sender().sendRichMessage("<gray><italic>Reloading configs... This will pause any active matches.");
        this.plugin.reloadMainConfig();
        this.boardManager.reload();
        ctx.sender().sendRichMessage("<green>Reloaded configs.");
    }

    private void createBoard(CommandContext<Player> ctx) {
        String name = (String)ctx.get("name");
        Player sender = ctx.sender();
        if (this.boardManager.board(name) != null) {
            sender.sendMessage(this.messages().boardAlreadyExists(name));
            return;
        }
        this.boardManager.createBoard(name, sender.getWorld(), Vec3i.fromBlockLocation(sender.getLocation()), (CardinalDirection)((Object)ctx.get("facing")), (Integer)ctx.get("scale"));
        sender.sendMessage(this.messages().boardCreated(name));
    }

    private void setCheckerboard(CommandContext<CommandSender> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        FlagContext flags = ctx.flags();
        board.applyCheckerboard(flags.getValue("black").orElse(Material.BLACK_CONCRETE), flags.getValue("white").orElse(Material.WHITE_CONCRETE), (Material)flags.get("border"));
        ctx.sender().sendRichMessage("<green>Set blocks to world.");
    }

    private void challengeCpu(CommandContext<Player> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        Player sender = ctx.sender();
        if (this.boardManager.inGame(sender)) {
            sender.sendMessage(this.messages().alreadyInGame());
            return;
        }
        if (Commands.canCancelCpuMatch(board)) {
            this.cancelCpuMatch(board);
        }
        if (board.hasGame() || board.autoCpuGame().cpuGamesOnly()) {
            sender.sendMessage(this.messages().boardOccupied(board.name()));
            return;
        }
        PieceColor userColor = (PieceColor)((Object)ctx.get("color"));
        ChessPlayer.Player user = ChessPlayer.player(sender);
        ChessPlayer cpu = ChessPlayer.cpu(ctx.getOrDefault("cpu_elo", Integer.valueOf(800)));
        board.startGame(userColor == PieceColor.WHITE ? user : cpu, userColor == PieceColor.BLACK ? user : cpu, ctx.optional("time_control").orElse(null));
    }

    private void challengePlayer(CommandContext<Player> ctx) {
        Player opponent;
        ChessBoard board = (ChessBoard)ctx.get("board");
        Player sender = ctx.sender();
        if (sender.equals((Object)(opponent = Objects.requireNonNull((Player)((SinglePlayerSelector)ctx.get("player")).single())))) {
            ctx.sender().sendRichMessage("<red>You cannot challenge yourself.");
            return;
        }
        if (this.boardManager.inGame(sender)) {
            sender.sendMessage(this.messages().alreadyInGame());
            return;
        }
        if (this.boardManager.inGame(opponent)) {
            sender.sendMessage(this.messages().opponentAlreadyInGame(opponent));
            return;
        }
        if (Commands.canCancelCpuMatch(board)) {
            this.cancelCpuMatch(board);
        } else if (board.hasGame() || board.autoCpuGame().cpuGamesOnly() || this.boardManager.challenges().asMap().values().stream().anyMatch(c -> c.board() == board)) {
            sender.sendMessage(this.messages().boardOccupied(board.name()));
            return;
        }
        PieceColor userColor = (PieceColor)((Object)ctx.get("color"));
        ChessPlayer.Player user = ChessPlayer.player(sender);
        ChessPlayer.Player opp = ChessPlayer.player(opponent);
        @Nullable TimeControlSettings timeControl = ctx.optional("time_control").orElse(null);
        this.boardManager.challenges().put((Object)opponent.getUniqueId(), (Object)new PVPChallengeImpl(board, sender, opponent, userColor, timeControl));
        sender.sendMessage(this.messages().challengeSent(user, opp, userColor));
        opponent.sendMessage(this.messages().challengeReceived(user, opp, userColor, timeControl));
    }

    private void cancelCpuMatch(ChessBoard board) {
        this.boardManager.delayAutoCpu(board);
        ChessGame game = board.game();
        board.endGameAndWait();
        game.audience().sendMessage(this.messages().matchCancelled());
    }

    private static boolean canCancelCpuMatch(ChessBoard board) {
        return board.hasGame() && board.game().cpuVsCpu() && board.autoCpuGame().enabled && board.autoCpuGame().allowPlayerUse;
    }

    private void accept(CommandContext<Player> ctx) {
        @Nullable PVPChallenge challenge = this.pollChallenge(ctx);
        if (challenge == null) {
            return;
        }
        if (this.boardManager.inGame(challenge.challenger())) {
            ctx.sender().sendMessage(this.messages().opponentAlreadyInGame(challenge.challenger()));
            return;
        }
        if (challenge instanceof PVPChallenge.ResumeMatch) {
            PVPChallenge.ResumeMatch resume = (PVPChallenge.ResumeMatch)challenge;
            resume.board().resumeGame(resume.state());
        } else {
            challenge.board().startGame(challenge.white(), challenge.black(), challenge.timeControl());
        }
    }

    private void deny(CommandContext<Player> ctx) {
        @Nullable PVPChallenge challenge = this.pollChallenge(ctx);
        if (challenge == null) {
            ctx.sender().sendMessage(this.messages().noPendingChallenge());
            return;
        }
        challenge.challenger().sendMessage(this.messages().challengeDenied(ChessPlayer.player(challenge.challenger()), ChessPlayer.player(challenge.player()), challenge.challengerColor()));
        ctx.sender().sendMessage(this.messages().challengeDeniedFeedback(ChessPlayer.player(challenge.challenger()), ChessPlayer.player(challenge.player()), challenge.challengerColor()));
    }

    private @Nullable PVPChallenge pollChallenge(CommandContext<Player> ctx) {
        Player sender = ctx.sender();
        @Nullable PVPChallenge challenge = (PVPChallenge)this.boardManager.challenges().getIfPresent((Object)sender.getUniqueId());
        if (challenge == null) {
            ctx.sender().sendMessage(this.messages().noPendingChallenge());
            return null;
        }
        this.boardManager.challenges().invalidate((Object)sender.getUniqueId());
        return challenge;
    }

    private void nextPromotion(CommandContext<Player> ctx) {
        Player sender = ctx.sender();
        ChessBoard board = this.playerBoard(sender);
        if (board == null) {
            sender.sendMessage(this.messages().mustBeInMatch());
            return;
        }
        PieceType type = (PieceType)((Object)ctx.get("type"));
        board.game().nextPromotion(sender, type);
        sender.sendMessage(this.messages().nextPromotionSet(type));
    }

    private void showLegalMoves(CommandContext<Player> ctx) {
        Player player = ctx.sender();
        boolean hidden = player.getPersistentDataContainer().has(ChessGame.HIDE_LEGAL_MOVES_KEY);
        if (hidden) {
            player.getPersistentDataContainer().remove(ChessGame.HIDE_LEGAL_MOVES_KEY);
        } else {
            player.getPersistentDataContainer().set(ChessGame.HIDE_LEGAL_MOVES_KEY, PersistentDataType.BYTE, (Object)1);
        }
        player.sendMessage(this.messages().showingLegalMoves(hidden));
    }

    private void deleteBoard(CommandContext<CommandSender> ctx) {
        String board = ((ChessBoard)ctx.get("board")).name();
        this.boardManager.deleteBoard(board);
        ctx.sender().sendMessage(this.messages().boardDeleted(board));
    }

    private void forfeit(CommandContext<Player> ctx) {
        Player sender = ctx.sender();
        ChessBoard board = this.playerBoard(sender);
        if (board == null) {
            sender.sendMessage(this.messages().mustBeInMatch());
            return;
        }
        board.game().forfeit(board.game().color(ChessPlayer.player(sender)));
    }

    private void resetBoard(CommandContext<CommandSender> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        if (board.hasGame()) {
            ctx.sender().sendMessage(this.messages().boardOccupied(board.name()));
            return;
        }
        board.reset(ctx.flags().hasFlag("clear"));
        ctx.sender().sendMessage(this.messages().resetBoard(board));
    }

    private void cpuMatch(CommandContext<CommandSender> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        if (ctx.flags().hasFlag("replace") && board.hasGame() && board.game().cpuVsCpu()) {
            this.cancelCpuMatch(board);
        }
        if (board.hasGame()) {
            ctx.sender().sendMessage(this.messages().boardOccupied(board.name()));
            return;
        }
        board.startCpuGame(ctx.flags().getValue("move_delay").orElse(4), ctx.flags().getValue("white_elo").orElse(1800), ctx.flags().getValue("black_elo").orElse(2400), ctx.flags().getValue("time_control", null));
        ChessGame game = board.game();
        ctx.sender().sendMessage(this.messages().matchStarted(board, game.white(), game.black()));
    }

    private void cancelMatch(CommandContext<CommandSender> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        if (!board.hasGame()) {
            ctx.sender().sendMessage(this.messages().noMatchToCancel(board.name()));
            return;
        }
        ChessGame game = board.game();
        board.endGameAndWait();
        game.audience().sendMessage(this.messages().matchCancelled());
        ctx.sender().sendMessage(this.messages().matchCancelled());
    }

    private void pauseMatch(CommandContext<Player> ctx) {
        Player sender = ctx.sender();
        ChessBoard board = this.playerBoard(sender);
        if (board == null) {
            sender.sendMessage(this.messages().mustBeInMatch());
            return;
        }
        ChessPlayer opponent = board.game().player(board.game().color(ChessPlayer.player(sender)).other());
        if (opponent.isCpu()) {
            this.boardManager.pauseMatch(board);
        } else {
            this.boardManager.pauseProposals().put((Object)((ChessPlayer.OnlinePlayer)opponent).uuid(), new Object());
            sender.sendMessage(this.messages().pauseProposedSender(board.game(), board.game().color(ChessPlayer.player(sender))));
            opponent.sendMessage(this.messages().pauseProposedRecipient(board.game(), board.game().color(ChessPlayer.player(sender)).other()));
        }
    }

    private void acceptPause(CommandContext<Player> ctx) {
        Player sender = ctx.sender();
        ChessBoard board = this.playerBoard(sender);
        if (board == null) {
            sender.sendMessage(this.messages().mustBeInMatch());
            return;
        }
        @Nullable Object proposal = this.boardManager.pauseProposals().getIfPresent((Object)sender.getUniqueId());
        if (proposal != null) {
            this.boardManager.pauseProposals().invalidate((Object)sender.getUniqueId());
            this.boardManager.pauseMatch(board);
        } else {
            sender.sendMessage(this.messages().noPauseProposed());
        }
    }

    private CompletableFuture<Void> resumeMatch(CommandContext<Player> ctx) {
        ChessBoard board = (ChessBoard)ctx.get("board");
        UUID id = (UUID)ctx.get("id");
        if (this.boardManager.inGame(ctx.sender())) {
            ctx.sender().sendMessage(this.messages().alreadyInGame());
            return CompletableFuture.completedFuture(null);
        }
        if (Commands.canCancelCpuMatch(board)) {
            this.cancelCpuMatch(board);
        } else if (board.hasGame() || board.autoCpuGame().cpuGamesOnly() || this.boardManager.challenges().asMap().values().stream().anyMatch(c -> c.board() == board)) {
            ctx.sender().sendMessage(this.messages().boardOccupied(board.name()));
            return CompletableFuture.completedFuture(null);
        }
        return this.plugin.database().queryMatch(id).thenAcceptAsync(matchOptional -> {
            if (matchOptional.isEmpty()) {
                ((Player)ctx.sender()).sendMessage(this.messages().noPausedMatch(id));
                return;
            }
            GameState match = (GameState)matchOptional.get();
            if (match.result() != null) {
                ((Player)ctx.sender()).sendMessage(this.messages().noPausedMatch(id));
                return;
            }
            @Nullable PieceColor color = match.color(((Player)ctx.sender()).getUniqueId());
            if (color == null) {
                throw CommandCompleted.withMessage((ComponentLike)this.messages().youAreNotInThisMatch());
            }
            if (!match.cpu(color.other())) {
                UUID opponentId = match.playerId(color.other());
                @Nullable Player player = Bukkit.getPlayer((UUID)opponentId);
                if (player == null) {
                    ((Player)ctx.sender()).sendMessage(this.messages().opponentOffline(this.plugin.database().onlineOrCachedPlayer(opponentId).join()));
                    return;
                }
                if (this.boardManager.inGame(player)) {
                    ((Player)ctx.sender()).sendMessage(this.messages().opponentAlreadyInGame(player));
                    return;
                }
                ((Player)ctx.sender()).sendMessage(this.messages().challengeSent(color == PieceColor.WHITE ? match.white() : match.black(), color == PieceColor.WHITE ? match.black() : match.white(), color));
                this.boardManager.challenges().put((Object)opponentId, (Object)new PVPChallengeResumeMatchImpl(board, (Player)ctx.sender(), player, color.other(), match.timeControlSettings(), match));
                player.sendMessage(this.messages().resumeChallengeReceived(color == PieceColor.WHITE ? match.white() : match.black(), color == PieceColor.WHITE ? match.black() : match.white(), color, match.timeControlSettings()));
                return;
            }
            board.resumeGame(match);
        }, this.plugin.getServer().getScheduler().getMainThreadExecutor((Plugin)this.plugin));
    }

    private CompletableFuture<TargetPlayer> target(CommandContext<? extends CommandSender> ctx) {
        return ctx.optional("player").map(offlinePlayer -> this.plugin.database().onlineOrCachedPlayer(offlinePlayer.getUniqueId()).thenApply(p -> new TargetPlayer(offlinePlayer.getUniqueId(), (ChessPlayer.Player)p))).orElseGet(() -> {
            Object patt0$temp = ctx.sender();
            if (patt0$temp instanceof Player) {
                Player p = (Player)patt0$temp;
                return CompletableFuture.completedFuture(new TargetPlayer(p.getUniqueId(), ChessPlayer.player(p)));
            }
            return CompletableFuture.failedFuture(CommandCompleted.withMessage((ComponentLike)this.messages().nonPlayerMustProvidePlayer()));
        });
    }

    private CompletableFuture<Void> pausedMatches(CommandContext<? extends CommandSender> ctx) {
        return this.target(ctx).thenCompose(target -> this.plugin.database().queryIncompleteMatches(target.uuid()).thenAcceptAsync(games -> {
            if (games.isEmpty()) {
                ((CommandSender)ctx.sender()).sendMessage(this.messages().noPausedMatches());
                return;
            }
            Pagination.builder().header((page, pages) -> this.messages().pausedMatchesHeader(target.player().name(), target.player().displayName())).footer(this.pagination.footerRenderer(Commands.commandString(ctx, "/chess paused_matches", target.uuid()))).item((item, lastOfPage) -> this.pagination.wrapElement((ComponentLike)this.messages().pausedMatchInfo(this.plugin.database(), (GameState)item, ((CommandSender)ctx.sender()).hasPermission("chesscraft.command.export_match.incomplete")))).pageOutOfRange(this.pagination.pageOutOfRange()).build().render((Collection<GameState>)games, ctx.optional("page").orElse(1), 5).forEach(arg_0 -> ((CommandSender)((CommandSender)ctx.sender())).sendMessage(arg_0));
        }));
    }

    private CompletableFuture<Void> matchHistory(CommandContext<? extends CommandSender> ctx) {
        return this.target(ctx).thenCompose(target -> this.plugin.database().queryCompleteMatches(target.uuid()).thenAcceptAsync(games -> {
            int n;
            if (games.isEmpty()) {
                ((CommandSender)ctx.sender()).sendMessage(this.messages().noCompleteMatches());
                return;
            }
            ChessPlayer.Player patt0$temp = target.player();
            if (patt0$temp instanceof ChessPlayer.CachedPlayer) {
                ChessPlayer.CachedPlayer cached = (ChessPlayer.CachedPlayer)patt0$temp;
                n = cached.rating();
            } else {
                n = this.plugin.database().queryPlayer(target.uuid()).join().map(ChessPlayer.CachedPlayer::rating).orElse(1000);
            }
            int rating = n;
            Pagination.builder().header((page, pages) -> this.messages().matchHistoryHeader(target.player().name(), target.player().displayName(), rating)).footer(this.pagination.footerRenderer(Commands.commandString(ctx, "/chess match_history", target.uuid()))).item((item, lastOfPage) -> this.pagination.wrapElement((ComponentLike)this.messages().completeMatchInfo(this.plugin.database(), (GameState)item, target.uuid(), true))).pageOutOfRange(this.pagination.pageOutOfRange()).build().render((Collection<GameState>)games, ctx.optional("page").orElse(1), 5).forEach(arg_0 -> ((CommandSender)((CommandSender)ctx.sender())).sendMessage(arg_0));
        }));
    }

    private static IntFunction<String> commandString(CommandContext<? extends CommandSender> ctx, String base, UUID player) {
        return page -> {
            Player sender;
            Object patt0$temp = ctx.sender();
            Object id = patt0$temp instanceof Player && (sender = (Player)patt0$temp).getUniqueId().equals(player) ? "" : " " + ctx.parsingContext("player").consumedInput();
            return base + (String)id + " page " + page;
        };
    }

    private CompletableFuture<Void> exportMatch(CommandContext<Player> ctx) {
        UUID id = (UUID)ctx.get("id");
        return this.plugin.database().queryMatch(id).thenAcceptAsync(matchOpt -> matchOpt.ifPresentOrElse(match -> {
            if (!(((Player)ctx.sender()).getUniqueId().equals(match.whiteId()) || ((Player)ctx.sender()).getUniqueId().equals(match.blackId()) || ((Player)ctx.sender()).hasPermission("chesscraft.command.export_match.others"))) {
                ((Player)ctx.sender()).sendMessage(this.messages().cannotExportOthers());
                return;
            }
            if (match.result() == null && !((Player)ctx.sender()).hasPermission("chesscraft.command.export_match.incomplete")) {
                ((Player)ctx.sender()).sendMessage(this.messages().cannotExportIncomplete());
                return;
            }
            ((Player)ctx.sender()).sendMessage(this.messages().clickToCopyPgn().clickEvent(ClickEvent.copyToClipboard((String)MatchExporter.writePgn(match, this.plugin.database()).join())));
        }, () -> ((Player)ctx.sender()).sendMessage(this.messages().noSuchMatch(id))));
    }

    private CompletableFuture<Void> leaderboard(CommandContext<CommandSender> ctx) {
        int limit = 8;
        return this.plugin.database().queryLeaderboard(8).thenAcceptAsync(leaderboard -> {
            ((CommandSender)ctx.sender()).sendMessage(this.messages().leaderboardHeader());
            for (int i = 0; i < 8; ++i) {
                try {
                    Pair pair = (Pair)leaderboard.get(i);
                    ChessPlayer player = this.plugin.database().onlineOrCachedPlayer((UUID)pair.first()).join();
                    Commands.leaderboardLine((CommandSender)ctx.sender(), i, player, pair);
                    continue;
                }
                catch (IndexOutOfBoundsException ignored) {
                    Commands.leaderboardLine((CommandSender)ctx.sender(), i, null, null);
                }
            }
        });
    }

    private static void leaderboardLine(CommandSender sender, int i, @Nullable ChessPlayer player, @Nullable Pair<UUID, Integer> pair) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)String.format("%2d", i + 1)))).append((Component)Component.text((String)". "));
        if (player != null && pair != null) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append(player.displayName())).append((Component)Component.text((String)": "))).append((Component)Component.text((int)pair.second()));
        } else {
            ((TextComponent.Builder)builder.append((Component)Component.text((String)"__________", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space());
        }
        sender.sendMessage((ComponentLike)builder);
    }

    private @Nullable ChessBoard playerBoard(Player sender) {
        return this.boardManager.activeBoards().stream().filter(b -> b.game().hasPlayer(sender)).findFirst().orElse(null);
    }

    private Messages messages() {
        return this.plugin.config().messages();
    }

    private static LegacyPaperCommandManager<CommandSender> createCommandManager(ChessCraft plugin) {
        LegacyPaperCommandManager<CommandSender> mgr = LegacyPaperCommandManager.createNative((Plugin)plugin, ExecutionCoordinator.simpleCoordinator());
        mgr.registerCommandPreProcessor(ctx -> ctx.commandContext().set(PLUGIN, plugin));
        mgr.registerBrigadier();
        BukkitBrigadierMapper<CommandSender> brigMapper = new BukkitBrigadierMapper<CommandSender>(plugin.getLogger(), mgr.brigadierManager());
        brigMapper.mapSimpleNMS(TypeToken.get(TimeControlParser.class), "resource_location", true);
        MinecraftExceptionHandler.createNative().defaultHandlers().captionFormatter(ComponentCaptionFormatter.miniMessage()).registerTo(mgr);
        mgr.exceptionController().registerHandler(CommandExecutionException.class, ExceptionHandler.unwrappingHandler(CommandCompleted.class)).registerHandler(CommandCompleted.class, ctx -> {
            @Nullable Component message = ((CommandCompleted)ctx.exception()).componentMessage();
            if (message != null) {
                ((CommandSender)ctx.context().sender()).sendMessage(message);
            }
        });
        AudienceLocaleExtractor extractor = AudienceLocaleExtractor.audienceLocaleExtractor();
        mgr.captionRegistry().registerProvider(TranslationBundle.core(extractor)).registerProvider(BukkitTranslationBundle.bukkit(extractor)).registerProvider(MinecraftExtrasTranslationBundle.minecraftExtras(extractor));
        return mgr;
    }

    private record TargetPlayer(UUID uuid, ChessPlayer.Player player) {
    }
}

