/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.util.Transformation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import xyz.jpenilla.chesscraft.BoardManager;
import xyz.jpenilla.chesscraft.BoardStateHolder;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.config.PieceOptions;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.CardinalDirection;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.util.MatchExporter;
import xyz.jpenilla.chesscraft.util.SteppedAnimation;

public interface PieceHandler {
    public void applyToWorld(ChessBoard var1, BoardStateHolder var2, World var3);

    default public void applyMoveToWorld(ChessBoard board, BoardStateHolder game, World world, ChessGame.Move move) {
        this.applyToWorld(board, game, world);
    }

    public void removeFromWorld(ChessBoard var1, World var2);

    private static List<Entity> pieceAt(World world, ChessBoard board, Vec3i pos) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.addAll(world.getNearbyEntities(pos.toLocation(world), 0.25, 0.5, 0.25, e -> e instanceof Display));
        entities.addAll(world.getNearbyEntities(DisplayEntity.interactionLoc(board, world, pos), 0.25, 0.5, 0.25, e -> e instanceof Interaction));
        entities.removeIf(entity -> !entity.getPersistentDataContainer().has(BoardManager.PIECE_KEY));
        return entities;
    }

    public static final class DisplayEntity
    implements PieceHandler {
        private static final int SHRINK_DURATION = 12;
        private static final int TELEPORT_DURATION = 5;
        private final ChessCraft plugin;
        private final PieceOptions.DisplayEntity options;
        private static final boolean v1_19_X = Bukkit.getServer().getMinecraftVersion().startsWith("1.19");

        public DisplayEntity(ChessCraft plugin, PieceOptions.DisplayEntity options) {
            this.plugin = plugin;
            this.options = options;
        }

        @Override
        public void applyToWorld(ChessBoard board, BoardStateHolder game, World world) {
            board.forEachPosition(boardPosition -> {
                Piece piece = game.piece((BoardPosition)boardPosition);
                Vec3i pos = board.toWorld((BoardPosition)boardPosition);
                if (piece == null) {
                    DisplayEntity.removePieceAt(world, board, pos);
                    return;
                }
                List<Entity> existing = PieceHandler.pieceAt(world, board, pos);
                Consumer<ItemDisplay> displayConfigure = itemDisplay -> {
                    this.configureItemDisplay(board, (ItemDisplay)itemDisplay, piece);
                    itemDisplay.setTeleportDuration(0);
                };
                @Nullable ItemDisplay existingItemDisplay = existing.stream().filter(it -> it instanceof ItemDisplay).findFirst().orElse(null);
                if (existingItemDisplay != null) {
                    displayConfigure.accept(existingItemDisplay);
                    existingItemDisplay.teleport(pos.toLocation(world));
                } else {
                    world.spawn(pos.toLocation(world), ItemDisplay.class, displayConfigure);
                }
                Consumer<Interaction> interactionConfigure = interaction -> this.configureInteraction(board, (Interaction)interaction, piece);
                @Nullable Interaction existingInteraction = existing.stream().filter(it -> it instanceof Interaction).findFirst().orElse(null);
                Location interactionLoc = DisplayEntity.interactionLoc(board, world, pos);
                if (existingInteraction != null) {
                    interactionConfigure.accept(existingInteraction);
                    existingInteraction.teleport(interactionLoc);
                } else {
                    world.spawn(interactionLoc, Interaction.class, interactionConfigure);
                }
            });
        }

        private void configureInteraction(ChessBoard board, Interaction interaction, Piece piece) {
            interaction.setInvulnerable(true);
            interaction.getPersistentDataContainer().set(BoardManager.PIECE_KEY, PersistentDataType.STRING, (Object)board.name());
            interaction.setResponsive(true);
            interaction.setInteractionHeight((float)this.options.height(piece.type()) * (float)board.scale());
            interaction.setInteractionWidth(0.5f * (float)board.scale());
        }

        private void configureItemDisplay(ChessBoard board, ItemDisplay itemDisplay, Piece piece) {
            itemDisplay.setTransformation(DisplayEntity.transformationFor(board, piece));
            itemDisplay.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
            itemDisplay.setItemStack(this.options.item(piece));
            itemDisplay.setInvulnerable(true);
            itemDisplay.getPersistentDataContainer().set(BoardManager.PIECE_KEY, PersistentDataType.STRING, (Object)board.name());
        }

        @Override
        public void applyMoveToWorld(ChessBoard board, BoardStateHolder game, World world, ChessGame.Move move) {
            board.animationExecutor().schedule(() -> this.makeAnimation(board, game, world, move));
        }

        private @Nullable SteppedAnimation makeAnimation(ChessBoard board, BoardStateHolder game, World world, ChessGame.Move move) {
            List<Entity> movedPieceEntities;
            BoardPosition fromPos = BoardPosition.fromString(move.notation().substring(0, 2));
            BoardPosition toPos = BoardPosition.fromString(move.notation().substring(2, 4));
            ArrayList<List<Entity>> captures = new ArrayList<List<Entity>>();
            board.forEachPosition(pos -> {
                List<Entity> entities;
                if (!pos.equals(fromPos) && game.piece((BoardPosition)pos) == null && (entities = PieceHandler.pieceAt(world, board, board.toWorld((BoardPosition)pos))).size() == 2) {
                    captures.add(entities);
                }
            });
            List<Entity> destEntities = PieceHandler.pieceAt(world, board, board.toWorld(toPos));
            if (destEntities.size() == 2) {
                captures.add(destEntities);
            }
            if ((movedPieceEntities = PieceHandler.pieceAt(world, board, board.toWorld(fromPos))).size() != 2) {
                this.inconsistentState(board, game, world, move);
                return null;
            }
            @Nullable Piece movedPiece = game.piece(toPos);
            if (movedPiece == null) {
                this.inconsistentState(board, game, world, move);
                return null;
            }
            SteppedAnimation.Builder animation = new SteppedAnimation.Builder();
            this.movePiece(board, world, movedPieceEntities, toPos, movedPiece, animation);
            if (movedPiece.type() == PieceType.KING && Math.abs(toPos.file() - fromPos.file()) == 2) {
                if (captures.size() != 1 || ((List)captures.getFirst()).size() != 2) {
                    this.inconsistentState(board, game, world, move);
                    return null;
                }
                List rook = (List)captures.getFirst();
                BoardPosition boardPosition = new BoardPosition(toPos.rank(), toPos.file() == 2 ? 3 : 5);
                this.movePiece(board, world, rook, boardPosition, game.piece(boardPosition), animation);
            } else {
                for (List list : captures) {
                    for (Entity entity : list) {
                        if (entity instanceof ItemDisplay) {
                            ItemDisplay display = (ItemDisplay)entity;
                            display.setInterpolationDuration(12);
                            display.setInterpolationDelay(-1);
                            animation.step(0, () -> {
                                Transformation transformation = display.getTransformation();
                                Vector3f scale = transformation.getScale().mul(0.01f);
                                display.setTransformation(new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), scale, transformation.getRightRotation()));
                            }).then(12, () -> ((ItemDisplay)display).remove());
                            continue;
                        }
                        entity.remove();
                    }
                }
            }
            return animation.startDelay(1).build();
        }

        private void inconsistentState(ChessBoard board, BoardStateHolder game, World world, ChessGame.Move move) {
            this.plugin.getSLF4JLogger().warn("Found inconsistent board state (move: {}), reapplying entire board\n{}", new Object[]{move.notation(), MatchExporter.writePgn(board.game().snapshotState(null), this.plugin.database()).join(), new Throwable()});
            this.applyToWorld(board, game, world);
        }

        private void movePiece(ChessBoard board, World world, List<Entity> movedPiece, BoardPosition toPos, Piece destPiece, SteppedAnimation.Builder animation) {
            for (Entity entity : movedPiece) {
                if (entity instanceof ItemDisplay) {
                    ItemDisplay display = (ItemDisplay)entity;
                    display.setTeleportDuration(5);
                    animation.step(0, () -> {
                        display.teleport(board.toWorld(toPos).toLocation(world));
                        world.playSound(board.moveSound(), display.getX(), display.getY(), display.getZ());
                        display.setTeleportDuration(0);
                    });
                    this.configureItemDisplay(board, display, destPiece);
                    continue;
                }
                if (!(entity instanceof Interaction)) continue;
                Interaction interaction = (Interaction)entity;
                Vec3i pos = board.toWorld(toPos);
                entity.teleport(DisplayEntity.interactionLoc(board, world, pos));
                this.configureInteraction(board, interaction, destPiece);
            }
        }

        private static Location interactionLoc(ChessBoard board, World world, Vec3i pos) {
            return new Location(world, (double)pos.x() + 0.5 * (double)board.scale(), (double)pos.y(), (double)pos.z() + 0.5 * (double)board.scale());
        }

        private static Transformation transformationFor(ChessBoard board, Piece piece) {
            Quaternionf left = new Quaternionf(new AxisAngle4f((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f));
            DisplayEntity.transformForVersion(left);
            Quaternionf right = new Quaternionf(new AxisAngle4f((float)Math.toRadians(DisplayEntity.rotation(board, piece)), 0.0f, 0.0f, 1.0f));
            return new Transformation(new Vector3f(0.5f * (float)board.scale(), 0.0f, 0.5f * (float)board.scale()), left, new Vector3f(0.5f * (float)board.scale()), right);
        }

        private static void transformForVersion(Quaternionf left) {
            if (v1_19_X) {
                return;
            }
            DisplayEntity.rotateYFlip(left);
        }

        private static void rotateYFlip(Quaternionf q) {
            float x = q.x;
            float y = q.y;
            float z = q.z;
            float w = q.w;
            q.x = -z;
            q.y = w;
            q.z = x;
            q.w = -y;
        }

        private static float rotation(ChessBoard board, Piece piece) {
            boolean eastWest;
            boolean bl = eastWest = !v1_19_X && (board.facing() == CardinalDirection.EAST || board.facing() == CardinalDirection.WEST);
            if (piece.color() == PieceColor.WHITE) {
                return (float)board.facing().degrees() + (float)(eastWest ? 180 : 0);
            }
            return (float)board.facing().degrees() + (float)(eastWest ? 0 : 180);
        }

        @Override
        public void removeFromWorld(ChessBoard board, World world) {
            board.forEachPosition(pos -> DisplayEntity.removePieceAt(world, board, board.toWorld((BoardPosition)pos)));
        }

        private static void removePieceAt(World world, ChessBoard board, Vec3i pos) {
            for (Entity entity : PieceHandler.pieceAt(world, board, pos)) {
                if (!entity.getPersistentDataContainer().has(BoardManager.PIECE_KEY)) continue;
                entity.remove();
            }
        }
    }

    public static final class PlayerHead
    implements PieceHandler {
        private final PieceOptions.PlayerHead options;

        public PlayerHead(PieceOptions.PlayerHead options) {
            this.options = options;
        }

        @Override
        public void applyToWorld(ChessBoard board, BoardStateHolder game, World world) {
            board.forEachPosition(boardPosition -> {
                Location loc = board.toWorld((BoardPosition)boardPosition).toLocation(world);
                Piece piece = game.piece((BoardPosition)boardPosition);
                if (piece == null) {
                    world.setType(loc, Material.AIR);
                    return;
                }
                world.setType(loc, Material.PLAYER_HEAD);
                Skull state = (Skull)world.getBlockState(loc);
                PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
                PlayerTextures textures = profile.getTextures();
                try {
                    textures.setSkin(URI.create("https://textures.minecraft.net/texture/" + this.options.texture(piece)).toURL());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                profile.setTextures(textures);
                state.setPlayerProfile(profile);
                state.update();
            });
        }

        @Override
        public void removeFromWorld(ChessBoard board, World world) {
            board.forEachPosition(boardPosition -> world.setType(board.toWorld((BoardPosition)boardPosition).toLocation(world), Material.AIR));
        }
    }

    public static final class ItemFrame
    implements PieceHandler {
        private final PieceOptions.ItemFrame options;

        public ItemFrame(PieceOptions.ItemFrame options) {
            this.options = options;
        }

        @Override
        public void applyToWorld(ChessBoard board, BoardStateHolder game, World world) {
            board.forEachPosition(boardPosition -> {
                Vec3i pos = board.toWorld((BoardPosition)boardPosition);
                ItemFrame.removePieceAt(world, pos);
                Piece piece = game.piece((BoardPosition)boardPosition);
                if (piece == null) {
                    return;
                }
                world.spawn(pos.toLocation(world), org.bukkit.entity.ItemFrame.class, itemFrame -> {
                    itemFrame.setRotation(ItemFrame.rotation(board.facing(), piece));
                    itemFrame.setItem(this.options.item(piece));
                    itemFrame.setFacingDirection(BlockFace.UP);
                    itemFrame.setInvulnerable(true);
                    itemFrame.setVisible(false);
                    itemFrame.getPersistentDataContainer().set(BoardManager.PIECE_KEY, PersistentDataType.STRING, (Object)board.name());
                });
                world.spawn(new Location(world, (double)pos.x() + 0.5, (double)pos.y() + this.options.heightOffset(piece.type()), (double)pos.z() + 0.5), ArmorStand.class, stand -> {
                    stand.setInvulnerable(true);
                    stand.getPersistentDataContainer().set(BoardManager.PIECE_KEY, PersistentDataType.STRING, (Object)board.name());
                    stand.setGravity(false);
                    stand.setInvisible(true);
                });
            });
        }

        private static Rotation rotation(CardinalDirection facing, Piece piece) {
            int i;
            Rotation rot = Rotation.NONE;
            double deg = facing.radians() * 180.0 / Math.PI;
            int rots = (int)(deg / 45.0);
            for (i = 0; i < rots; ++i) {
                rot = rot.rotateClockwise();
            }
            if (piece.color() == PieceColor.BLACK) {
                return rot;
            }
            for (i = 0; i < 4; ++i) {
                rot = rot.rotateClockwise();
            }
            return rot;
        }

        @Override
        public void removeFromWorld(ChessBoard board, World world) {
            board.forEachPosition(pos -> ItemFrame.removePieceAt(world, board.toWorld((BoardPosition)pos)));
        }

        private static void removePieceAt(World world, Vec3i pos) {
            Collection entities = world.getNearbyEntities(new Location(world, (double)pos.x() + 0.5, (double)pos.y(), (double)pos.z() + 0.5), 0.25, 0.5, 0.25, e -> (e instanceof org.bukkit.entity.ItemFrame || e instanceof ArmorStand) && e.getPersistentDataContainer().has(BoardManager.PIECE_KEY));
            for (Entity entity : entities) {
                entity.remove();
            }
        }
    }
}

