/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.config.Messages;
import xyz.jpenilla.chesscraft.data.Fen;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.db.Database;
import xyz.jpenilla.chesscraft.util.Elo;

public record GameState(UUID id, @Nullable UUID whiteId, int whiteElo, @Nullable ChessGame.TimeControl whiteTime, @Nullable UUID blackId, int blackElo, @Nullable ChessGame.TimeControl blackTime, List<ChessGame.Move> moves, Fen currentFen, int cpuMoveDelay, @Nullable TimeControlSettings timeControlSettings, @Nullable Result result, Timestamp lastUpdated) {
    public boolean whiteCpu() {
        return this.whiteId == null;
    }

    public boolean blackCpu() {
        return this.blackId == null;
    }

    public ChessPlayer white() {
        return this.whiteCpu() ? ChessPlayer.cpu(this.whiteElo()) : ChessPlayer.player(Objects.requireNonNull(Bukkit.getPlayer((UUID)this.whiteId())));
    }

    public ChessPlayer black() {
        return this.blackCpu() ? ChessPlayer.cpu(this.blackElo()) : ChessPlayer.player(Objects.requireNonNull(Bukkit.getPlayer((UUID)this.blackId())));
    }

    public CompletableFuture<? extends ChessPlayer> whiteOffline(Database db) {
        return this.whiteCpu() ? CompletableFuture.completedFuture(ChessPlayer.cpu(this.whiteElo())) : db.onlineOrCachedPlayer(this.whiteId());
    }

    public CompletableFuture<? extends ChessPlayer> blackOffline(Database db) {
        return this.blackCpu() ? CompletableFuture.completedFuture(ChessPlayer.cpu(this.blackElo())) : db.onlineOrCachedPlayer(this.blackId());
    }

    public boolean playersOnline() {
        try {
            this.black();
            this.white();
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public PieceColor color(UUID playerId) {
        if (playerId.equals(this.whiteId)) {
            return PieceColor.WHITE;
        }
        if (playerId.equals(this.blackId)) {
            return PieceColor.BLACK;
        }
        return null;
    }

    public UUID playerId(PieceColor color) {
        if (color == PieceColor.WHITE) {
            return this.whiteId;
        }
        return this.blackId;
    }

    public boolean cpu(PieceColor color) {
        if (color == PieceColor.WHITE) {
            return this.whiteCpu();
        }
        return this.blackCpu();
    }

    public Elo.MatchOutcome matchOutcome() {
        ResultType type = Objects.requireNonNull(this.result(), "result").type();
        if (type == ResultType.STALEMATE || type == ResultType.DRAW_BY_50 || type == ResultType.REPETITION) {
            return Elo.MatchOutcome.DRAW;
        }
        if (type == ResultType.WIN) {
            return this.result().color() == PieceColor.WHITE ? Elo.MatchOutcome.PLAYER_ONE_WIN : Elo.MatchOutcome.PLAYER_TWO_WIN;
        }
        return this.result().color() == PieceColor.WHITE ? Elo.MatchOutcome.PLAYER_TWO_WIN : Elo.MatchOutcome.PLAYER_ONE_WIN;
    }

    public record Result(ResultType type, PieceColor color, int whiteEloChange, int blackEloChange) {
        static Result create(ResultType type, PieceColor color) {
            return new Result(type, color, -1, -1);
        }

        public Component describe(Messages messages) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> messages.resultWin(this.color);
                case 1 -> messages.resultOutOfTime(this.color);
                case 2 -> messages.resultStalemate();
                case 3 -> messages.resultDrawByRepetition();
                case 4 -> messages.resultDrawByFiftyMoveRule();
                case 5 -> messages.resultForfeit(this.color);
            };
        }

        public boolean noRatingChange() {
            return this.whiteEloChange == 0 && this.blackEloChange == 0;
        }
    }

    public static enum ResultType {
        WIN,
        OUT_OF_TIME,
        STALEMATE,
        REPETITION,
        DRAW_BY_50,
        FORFEIT;

    }
}

