/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import xyz.jpenilla.chesscraft.util.Elo;

public interface ChessPlayer
extends Audience {
    default public Component displayName() {
        return this.name();
    }

    public Component name();

    default public boolean isCpu() {
        return this instanceof Cpu;
    }

    public static Player player(org.bukkit.entity.Player player) {
        return new OnlinePlayer(player.getUniqueId());
    }

    public static Player offlinePlayer(final OfflinePlayer offlinePlayer) {
        return new Player(){

            @Override
            public Component name() {
                return Component.text((String)offlinePlayer.getName());
            }

            @Override
            public Component displayName() {
                if (offlinePlayer.isOnline()) {
                    return offlinePlayer.getPlayer().displayName();
                }
                return Player.super.displayName();
            }

            @Override
            public UUID uuid() {
                return offlinePlayer.getUniqueId();
            }
        };
    }

    public static ChessPlayer cpu(int elo) {
        return new Cpu(elo, UUID.randomUUID());
    }

    public record Cpu(int elo, UUID id) implements ChessPlayer,
    ForwardingAudience.Single
    {
        private static final Component NAME = Component.text((String)"CPU");

        public Audience audience() {
            return Audience.empty();
        }

        @Override
        public Component name() {
            return NAME;
        }
    }

    public record OnlinePlayer(UUID uuid) implements Player,
    ForwardingAudience.Single
    {
        public Audience audience() {
            return this.player();
        }

        @Override
        public Component displayName() {
            return this.player().displayName();
        }

        @Override
        public Component name() {
            return Component.text((String)this.player().getName());
        }

        public org.bukkit.entity.Player player() {
            return Objects.requireNonNull(Bukkit.getPlayer((UUID)this.uuid), "Player with UUID " + String.valueOf(this.uuid) + " not logged in.");
        }
    }

    public record CachedPlayer(UUID uuid, Component name, Component displayName, int rating, int peakRating, int ratedMatches) implements Player
    {
        public Elo.RatingData ratingData() {
            return new Elo.RatingData(this.rating, this.peakRating, this.ratedMatches);
        }
    }

    public static interface Player
    extends ChessPlayer {
        public UUID uuid();
    }
}

