/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import com.destroystokyo.paper.ParticleBuilder;
import com.destroystokyo.paper.util.SneakyThrow;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.BoardStateHolder;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.Fen;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.QueryTypes;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.StockfishClient;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Option;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishInitException;
import xyz.jpenilla.chesscraft.display.AbstractTextDisplayHolder;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;
import xyz.jpenilla.chesscraft.util.TimeUtil;
import xyz.jpenilla.chesscraft.util.Util;

public final class ChessGame
implements BoardStateHolder {
    public static final NamespacedKey HIDE_LEGAL_MOVES_KEY = new NamespacedKey("chesscraft", "hide_legal_moves");
    private final UUID id;
    private final ChessBoard board;
    private final StockfishClient stockfish;
    private final Piece[][] pieces;
    private final ChessCraft plugin;
    private final ChessPlayer white;
    private final ChessPlayer black;
    private final int moveDelay;
    private final CountDownLatch delayLatch = new CountDownLatch(1);
    private final TimeControlSettings timeControlSettings;
    private PieceType whiteNextPromotion = PieceType.QUEEN;
    private PieceType blackNextPromotion = PieceType.QUEEN;
    private final @Nullable TimeControl whiteTime;
    private final @Nullable TimeControl blackTime;
    private final @Nullable BukkitTask timeControlTask;
    private final List<Move> moves;
    private final List<Pair<BoardDisplaySettings<?>, ?>> displays = new ArrayList();
    private String currentFen;
    private PieceColor nextMove;
    private String selectedPiece;
    private Set<String> validDestinations;
    private CompletableFuture<?> activeQuery;
    private volatile boolean active = true;

    ChessGame(ChessCraft plugin, ChessBoard board, ChessPlayer white, ChessPlayer black, @Nullable TimeControlSettings timeControl, int moveDelay) {
        this.id = UUID.randomUUID();
        this.plugin = plugin;
        this.board = board;
        this.white = white;
        this.black = black;
        this.pieces = ChessBoard.initBoard();
        this.moves = new CopyOnWriteArrayList<Move>();
        this.moveDelay = moveDelay;
        this.loadFen(Fen.STARTING_FEN);
        try {
            this.stockfish = this.createStockfishClient();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize and/or connect to chess engine process", ex);
        }
        if (timeControl != null) {
            this.whiteTime = new TimeControl(timeControl);
            this.blackTime = new TimeControl(timeControl);
            this.timeControlTask = plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::tickTime, 0L, 1L);
        } else {
            this.whiteTime = null;
            this.blackTime = null;
            this.timeControlTask = null;
        }
        this.timeControlSettings = timeControl;
        for (BoardDisplaySettings<?> display : this.board.displays()) {
            this.displays.add(Pair.of(display, display.getOrCreateState(this.plugin, this.board)));
        }
        this.scheduleApply();
    }

    ChessGame(ChessCraft plugin, ChessBoard board, GameState state) {
        this.id = state.id();
        this.plugin = plugin;
        this.board = board;
        this.white = state.white();
        this.black = state.black();
        this.pieces = ChessBoard.initBoard();
        this.moves = new CopyOnWriteArrayList<Move>(state.moves());
        this.moveDelay = state.cpuMoveDelay();
        this.loadFen(state.currentFen());
        try {
            this.stockfish = this.createStockfishClient();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize and/or connect to chess engine process", ex);
        }
        this.whiteTime = state.whiteTime() == null ? null : state.whiteTime().copy();
        this.blackTime = state.blackTime() == null ? null : state.blackTime().copy();
        this.timeControlTask = this.whiteTime != null || this.blackTime != null ? plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::tickTime, 0L, 1L) : null;
        this.timeControlSettings = state.timeControlSettings();
        for (BoardDisplaySettings<?> display : this.board.displays()) {
            this.displays.add(Pair.of(display, display.getOrCreateState(this.plugin, this.board)));
        }
        this.scheduleApply();
    }

    public GameState snapshotState(@Nullable GameState.Result result) {
        int n;
        UUID uUID;
        int n2;
        ChessPlayer.Cpu cpu;
        UUID uUID2;
        ChessPlayer.Player player;
        ChessPlayer chessPlayer = this.white;
        if (chessPlayer instanceof ChessPlayer.Player) {
            player = (ChessPlayer.Player)chessPlayer;
            uUID2 = player.uuid();
        } else {
            uUID2 = null;
        }
        chessPlayer = this.white;
        if (chessPlayer instanceof ChessPlayer.Cpu) {
            cpu = (ChessPlayer.Cpu)chessPlayer;
            n2 = cpu.elo();
        } else {
            n2 = -1;
        }
        TimeControl timeControl = this.whiteTime == null ? null : this.whiteTime.copy();
        chessPlayer = this.black;
        if (chessPlayer instanceof ChessPlayer.Player) {
            player = (ChessPlayer.Player)chessPlayer;
            uUID = player.uuid();
        } else {
            uUID = null;
        }
        chessPlayer = this.black;
        if (chessPlayer instanceof ChessPlayer.Cpu) {
            cpu = (ChessPlayer.Cpu)chessPlayer;
            n = cpu.elo();
        } else {
            n = -1;
        }
        return new GameState(this.id, uUID2, n2, timeControl, uUID, n, this.blackTime == null ? null : this.blackTime.copy(), List.copyOf(this.moves), Fen.read(this.currentFen), this.moveDelay, this.timeControlSettings, result, Timestamp.valueOf(LocalDateTime.now()));
    }

    public ChessPlayer white() {
        return this.white;
    }

    public ChessPlayer black() {
        return this.black;
    }

    public boolean cpuVsCpu() {
        return this.white.isCpu() && this.black.isCpu();
    }

    public PieceColor nextMove() {
        return this.nextMove;
    }

    public void handleInteract(Player player, BoardPosition rightClicked) {
        PieceColor color = this.color(ChessPlayer.player(player));
        if (color == null) {
            player.sendMessage(this.plugin.config().messages().notInThisGame());
            return;
        }
        if (color != this.nextMove) {
            player.sendMessage(this.plugin.config().messages().notYourMove());
            return;
        }
        if (this.activeQuery != null && !this.activeQuery.isDone()) {
            player.sendMessage(this.plugin.config().messages().chessEngineProcessing());
            return;
        }
        String selNotation = rightClicked.notation();
        Piece selPiece = this.piece(rightClicked);
        if (this.selectedPiece == null && selPiece != null) {
            if (selPiece.color() != color) {
                player.sendMessage(this.plugin.config().messages().notYourPiece());
                return;
            }
            this.activeQuery = this.selectPiece(selNotation);
        } else if (selNotation.equals(this.selectedPiece)) {
            this.selectedPiece = null;
            this.validDestinations = null;
        } else if (this.validDestinations != null && this.validDestinations.contains(selNotation)) {
            this.activeQuery = this.move(this.selectedPiece + selNotation, color).exceptionally(ex -> {
                this.plugin.getLogger().log(Level.WARNING, "Exception executing move", (Throwable)ex);
                return null;
            });
            this.validDestinations = null;
            this.selectedPiece = null;
        } else if (this.selectedPiece != null) {
            player.sendMessage(this.plugin.config().messages().invalidMove());
        }
    }

    public void displayParticles() {
        if (this.selectedPiece == null) {
            return;
        }
        Vec3i selectedPos = this.board.toWorld(this.selectedPiece);
        ChessPlayer c = this.player(this.nextMove);
        if (!(c instanceof ChessPlayer.OnlinePlayer)) {
            return;
        }
        ChessPlayer.OnlinePlayer chessPlayer = (ChessPlayer.OnlinePlayer)c;
        Player player = chessPlayer.player();
        this.blockParticles(player, selectedPos, Color.AQUA);
        if (this.validDestinations != null && !player.getPersistentDataContainer().has(HIDE_LEGAL_MOVES_KEY)) {
            this.validDestinations.stream().map(this.board::toWorld).forEach(pos -> this.blockParticles(player, (Vec3i)pos, Color.GREEN));
        }
    }

    private void blockParticles(Player player, Vec3i block, Color particleColor) {
        double min = 0.18 * (double)this.board.scale();
        double max = 0.82 * (double)this.board.scale();
        double minX = (double)block.x() + min;
        double minZ = (double)block.z() + min;
        double maxX = (double)block.x() + max;
        double maxZ = (double)block.z() + max;
        boolean handledMaxCorner = false;
        for (double x = minX; x <= maxX; x += 0.2) {
            ChessGame.particle(player, particleColor, x, block.y(), minZ);
            ChessGame.particle(player, particleColor, x, block.y(), maxZ);
            if (x != maxX) continue;
            handledMaxCorner = true;
        }
        if (!handledMaxCorner) {
            ChessGame.particle(player, particleColor, maxX, block.y(), minZ);
            ChessGame.particle(player, particleColor, maxX, block.y(), maxZ);
        }
        for (double z = minZ + 0.2; z <= maxZ - 0.2; z += 0.2) {
            ChessGame.particle(player, particleColor, minX, block.y(), z);
            ChessGame.particle(player, particleColor, maxX, block.y(), z);
        }
    }

    private static void particle(Player player, Color particleColor, double x, double y, double z) {
        new ParticleBuilder(Particle.DUST).count(1).color(particleColor).offset(0.0, 0.0, 0.0).location(player.getWorld(), x, y, z).receivers(new Player[]{player}).spawn();
    }

    @Override
    public @Nullable Piece piece(BoardPosition pos) {
        return this.pieces[pos.rank()][pos.file()];
    }

    public BoardStateHolder snapshotPieces() {
        Piece[][] copy = ChessBoard.initBoard();
        for (int i = 0; i < this.pieces.length; ++i) {
            System.arraycopy(this.pieces[i], 0, copy[i], 0, this.pieces[i].length);
        }
        return BoardStateHolder.of(copy);
    }

    public ChessPlayer player(PieceColor color) {
        if (color == PieceColor.WHITE) {
            return this.white;
        }
        if (color == PieceColor.BLACK) {
            return this.black;
        }
        throw new IllegalArgumentException();
    }

    public @Nullable PieceColor color(ChessPlayer player) {
        if (player.equals(this.white)) {
            return PieceColor.WHITE;
        }
        if (player.equals(this.black)) {
            return PieceColor.BLACK;
        }
        return null;
    }

    public boolean hasPlayer(Player player) {
        ChessPlayer.Player p;
        ChessPlayer.Player chessPlayer = ChessPlayer.player(player);
        ChessPlayer chessPlayer2 = this.white;
        if (chessPlayer2 instanceof ChessPlayer.Player && (p = (ChessPlayer.Player)chessPlayer2).uuid().equals(chessPlayer.uuid())) {
            return true;
        }
        chessPlayer2 = this.black;
        return chessPlayer2 instanceof ChessPlayer.Player && (p = (ChessPlayer.Player)chessPlayer2).uuid().equals(chessPlayer.uuid());
    }

    private void scheduleApply() {
        this.scheduleApply(null);
    }

    private void scheduleApply(@Nullable Move move) {
        BoardStateHolder snapshot = this.snapshotPieces();
        Util.scheduleOrRun(this.plugin, () -> this.applyToWorld(snapshot, move));
    }

    private void applyToWorld(BoardStateHolder snapshot) {
        this.applyToWorld(snapshot, null);
    }

    private void applyToWorld(BoardStateHolder snapshot, @Nullable Move move) {
        if (move == null) {
            this.board.pieceHandler().applyToWorld(this.board, snapshot, this.board.world());
        } else {
            this.board.pieceHandler().applyMoveToWorld(this.board, snapshot, this.board.world(), move);
        }
        for (Pair<BoardDisplaySettings<?>, ?> pair : this.displays) {
            Object object = pair.second();
            if (!(object instanceof AbstractTextDisplayHolder)) continue;
            AbstractTextDisplayHolder t = (AbstractTextDisplayHolder)object;
            t.ensureSpawned();
            t.updateNow();
        }
    }

    private CompletableFuture<Void> selectPiece(String sel) {
        return ((CompletableFuture)this.stockfish.submit(QueryTypes.LEGAL_MOVES.builder(this.currentFen).build()).thenAccept(legal -> {
            this.selectedPiece = sel;
            this.validDestinations = legal.stream().filter(move -> move.startsWith(sel)).map(move -> move.substring(2, 4)).collect(Collectors.toSet());
        })).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.WARNING, "Failed to query valid moves", (Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Void> move(String move, PieceColor color) {
        if (color != this.nextMove) {
            throw new IllegalArgumentException("Wrong move");
        }
        return ((CompletableFuture)this.stockfish.submit(QueryTypes.LEGAL_MOVES.builder(this.currentFen).build()).thenCompose(validMoves -> {
            if (validMoves.stream().noneMatch(valid -> valid.equals(move) || valid.startsWith(move))) {
                throw new IllegalArgumentException("Invalid move");
            }
            String finalMove = validMoves.contains(move) ? move : move + this.nextPromotionAndReset(color);
            Move movePair = new Move(finalMove, color, null);
            if (!this.active) {
                return CompletableFuture.completedFuture(null);
            }
            return this.stockfish.submit(QueryTypes.MAKE_MOVES.builder(Fen.STARTING_FEN.fenString()).setMoves(this.moveSequenceString(movePair)).build()).thenCompose(newFen -> {
                Fen fen = Fen.read(newFen);
                this.loadFen(fen);
                this.moves.add(movePair.boardAfter(fen));
                this.scheduleApply(movePair);
                this.audience().sendMessage(this.plugin.config().messages().madeMove(this.player(color), this.player(color.other()), color, finalMove));
                return this.checkForWinAfterMove();
            });
        })).thenCompose($ -> {
            if (this.player(this.nextMove).isCpu() && this.active) {
                return this.cpuMoveFuture();
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private String moveSequenceString(Move ... extraMoves) {
        return Stream.concat(this.moves.stream(), Arrays.stream(extraMoves)).map(Move::notation).collect(Collectors.joining(" "));
    }

    private String moveSequenceString() {
        return this.moves.stream().map(Move::notation).collect(Collectors.joining(" "));
    }

    private CompletableFuture<Void> checkForWinAfterMove() {
        Move lastMove = this.moves.getLast();
        long timesPositionSeen = this.moves.stream().filter(e -> Objects.deepEquals(e.boardAfter().pieces(), lastMove.boardAfter().pieces())).count();
        if (timesPositionSeen == 3L) {
            this.announceDrawByRepetition();
            this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.REPETITION, null)), true);
            this.board.endGame();
            return CompletableFuture.completedFuture(null);
        }
        if (this.moves.size() > 100) {
            List<Move> last100 = Util.peekLast(this.moves, 100);
            boolean draw = true;
            Reference2IntMap<PieceType> lastCounts = null;
            Map<IntIntPair, Piece> lastPawns = null;
            for (Move move : last100) {
                Reference2IntMap<PieceType> newCounts = move.boardAfter().pieceTotals();
                if (lastCounts != null && !newCounts.equals(lastCounts)) {
                    draw = false;
                    break;
                }
                lastCounts = newCounts;
                Map<IntIntPair, Piece> newPawns = move.boardAfter().pawnPositions();
                if (lastPawns != null && !newPawns.equals(lastPawns)) {
                    draw = false;
                    break;
                }
                lastPawns = newPawns;
            }
            if (draw) {
                this.announceDrawByFifty();
                this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.DRAW_BY_50, null)), true);
                this.board.endGame();
                return CompletableFuture.completedFuture(null);
            }
        }
        return this.stockfish.submit(QueryTypes.LEGAL_MOVES.builder(this.currentFen).build()).thenCompose(legal -> {
            if (!legal.isEmpty()) {
                TimeControl time;
                TimeControl timeControl = time = this.nextMove == PieceColor.WHITE ? this.blackTime : this.whiteTime;
                if (time != null) {
                    time.move();
                }
                return CompletableFuture.completedFuture(null);
            }
            return this.stockfish.submit(QueryTypes.CHECKERS.builder(this.currentFen).build()).thenAccept(checkers -> {
                if (checkers.isEmpty()) {
                    this.announceStalemate();
                    this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.STALEMATE, null)), true);
                } else {
                    this.announceWin(this.nextMove == PieceColor.WHITE ? PieceColor.BLACK : PieceColor.WHITE);
                    this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.WIN, this.nextMove == PieceColor.WHITE ? PieceColor.BLACK : PieceColor.WHITE)), true);
                }
                this.board.endGame();
            });
        });
    }

    void cpuMove() {
        if (this.activeQuery != null && !this.activeQuery.isDone() || !this.player(this.nextMove).isCpu()) {
            throw new IllegalStateException();
        }
        this.activeQuery = this.cpuMoveFuture().exceptionally(ex -> {
            this.plugin.getLogger().log(Level.WARNING, "Exception executing move", (Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Void> cpuMoveFuture() {
        this.audience().sendMessage(this.plugin.config().messages().cpuThinking(this.nextMove));
        return this.moveDelayFuture().thenCompose($ -> {
            if (!this.active) {
                return CompletableFuture.completedFuture(null);
            }
            return this.stockfish.submit(QueryTypes.BEST_MOVE.builder(Fen.STARTING_FEN.fenString()).setMoves(this.moveSequenceString()).setMovetime(500L).setUciElo(((ChessPlayer.Cpu)this.player(this.nextMove)).elo()).build()).thenCompose(bestMove -> {
                if (!this.active) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.move((String)bestMove, this.nextMove);
            });
        });
    }

    private CompletableFuture<Void> moveDelayFuture() {
        if (this.moveDelay == -1) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this.delayLatch.await(this.moveDelay, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public Audience audience() {
        ArrayList<Audience> audiences = new ArrayList<Audience>();
        audiences.add(this.white);
        audiences.add(this.black);
        for (Pair<BoardDisplaySettings<?>, ?> pair : this.displays) {
            Object object = pair.second();
            if (!(object instanceof Audience)) continue;
            Audience audience = (Audience)object;
            audiences.add(audience);
        }
        return Audience.audience(audiences);
    }

    private void announceWin(PieceColor winner) {
        this.audience().sendMessage(this.plugin.config().messages().checkmate(this.black, this.white, winner));
    }

    private void announceStalemate() {
        this.audience().sendMessage(this.plugin.config().messages().stalemate(this.black, this.white));
    }

    private void announceDrawByRepetition() {
        this.audience().sendMessage(this.plugin.config().messages().drawByRepetition(this.black, this.white));
    }

    private void announceDrawByFifty() {
        this.audience().sendMessage(this.plugin.config().messages().drawByFiftyMoveRule(this.black, this.white));
    }

    public void forfeit(PieceColor color) {
        this.board.endGameAndWait();
        this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.FORFEIT, color)), true);
        this.audience().sendMessage(this.plugin.config().messages().forfeit(this.black, this.white, color));
    }

    private String nextPromotionAndReset(PieceColor color) {
        switch (color) {
            case WHITE: {
                PieceType next = this.whiteNextPromotion;
                this.whiteNextPromotion = PieceType.QUEEN;
                return next.lower();
            }
            case BLACK: {
                PieceType next = this.blackNextPromotion;
                this.blackNextPromotion = PieceType.QUEEN;
                return next.lower();
            }
        }
        throw new IllegalArgumentException();
    }

    public void close(boolean removePieces, boolean wait) {
        CompletableFuture<?> query;
        this.active = false;
        this.delayLatch.countDown();
        if (wait && (query = this.activeQuery) != null) {
            try {
                query.get(5L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                SneakyThrow.sneaky((Throwable)e);
            }
        }
        if (removePieces) {
            this.board.pieceHandler().removeFromWorld(this.board, this.board.world());
        }
        if (this.timeControlTask != null) {
            this.timeControlTask.cancel();
        }
        for (Pair<BoardDisplaySettings<?>, ?> pair : this.displays) {
            if (((BoardDisplaySettings)pair.first()).removeAfterGame()) {
                ((BoardDisplaySettings)pair.first()).remove(pair.second());
            }
            ((BoardDisplaySettings)pair.first()).gameEnded(pair.second());
        }
        this.stockfish.close();
    }

    public void reset() {
        if (this.activeQuery != null && !this.activeQuery.isDone()) {
            throw new IllegalStateException();
        }
        this.activeQuery = this.stockfish.uciNewGame();
        this.activeQuery.join();
        this.loadFen(Fen.STARTING_FEN);
        this.applyToWorld(this.snapshotPieces());
    }

    private void loadFen(Fen fen) {
        this.currentFen = fen.fenString();
        this.nextMove = fen.nextMove();
        System.arraycopy(fen.pieces(), 0, this.pieces, 0, fen.pieces().length);
    }

    public void nextPromotion(Player sender, PieceType type) {
        ChessPlayer.Player player = ChessPlayer.player(sender);
        if (player.equals(this.white)) {
            this.whiteNextPromotion = type;
        } else if (player.equals(this.black)) {
            this.blackNextPromotion = type;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private StockfishClient createStockfishClient() throws StockfishInitException {
        StockfishClient.Builder builder = new StockfishClient.Builder().setPath(this.board.stockfishPath()).setOption(Option.Threads, 2);
        return builder.build();
    }

    private void tickTime() {
        Objects.requireNonNull(this.whiteTime, "whiteTime");
        Objects.requireNonNull(this.blackTime, "blackTime");
        if (this.nextMove == PieceColor.WHITE && this.whiteTime.tick()) {
            this.audience().sendMessage(this.plugin.config().messages().ranOutOfTime(this, PieceColor.WHITE));
            this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.OUT_OF_TIME, PieceColor.WHITE)), true);
            this.board.endGame();
        } else if (this.nextMove == PieceColor.BLACK && this.blackTime.tick()) {
            this.audience().sendMessage(this.plugin.config().messages().ranOutOfTime(this, PieceColor.BLACK));
            this.plugin.database().saveMatchAsync(this.snapshotState(GameState.Result.create(GameState.ResultType.OUT_OF_TIME, PieceColor.BLACK)), true);
            this.board.endGame();
        }
        if (this.plugin.getServer().getCurrentTick() % 4 == 0) {
            this.white.sendActionBar(this.plugin.config().messages().timeDisplay(this, PieceColor.WHITE));
            this.black.sendActionBar(this.plugin.config().messages().timeDisplay(this, PieceColor.BLACK));
        }
    }

    public TimeControl time(ChessPlayer player) {
        if (player.equals(this.white)) {
            return this.whiteTime;
        }
        if (player.equals(this.black)) {
            return this.blackTime;
        }
        throw new IllegalArgumentException();
    }

    public static final class TimeControl {
        private final long increment;
        private volatile long timeLeft;

        TimeControl(TimeControlSettings timeControl) {
            this.timeLeft = timeControl.time().toSeconds() * 20L;
            this.increment = timeControl.increment().toSeconds() * 20L;
        }

        public TimeControl(long timeLeft, long increment) {
            this.timeLeft = timeLeft;
            this.increment = increment;
        }

        synchronized void move() {
            this.timeLeft += this.increment;
        }

        synchronized boolean tick() {
            --this.timeLeft;
            return this.timeLeft < 1L;
        }

        public String timeLeftString() {
            Duration d = Duration.ofMillis(Math.round((double)this.timeLeft / 20.0 * 1000.0));
            return TimeUtil.formatDurationClock(d);
        }

        public TimeControl copy() {
            return new TimeControl(this.timeLeft, this.increment);
        }
    }

    public record Move(String notation, PieceColor color, @Nullable Fen boardAfter) {
        private final @Nullable Fen boardAfter;

        public Move boardAfter(Fen fen) {
            return new Move(this.notation, this.color, fen);
        }

        public Fen boardAfter() {
            return Objects.requireNonNull(this.boardAfter);
        }
    }
}

