/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import java.nio.file.Path;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import xyz.jpenilla.chesscraft.BoardManager;
import xyz.jpenilla.chesscraft.command.Commands;
import xyz.jpenilla.chesscraft.config.ConfigHelper;
import xyz.jpenilla.chesscraft.config.MainConfig;
import xyz.jpenilla.chesscraft.db.Database;
import xyz.jpenilla.chesscraft.dependency.org.bstats.bukkit.Metrics;
import xyz.jpenilla.chesscraft.util.StockfishProvider;

public final class ChessCraft
extends JavaPlugin {
    private final Deque<Runnable> shutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private BoardManager boardManager;
    private Database database;
    private @MonotonicNonNull MainConfig config;

    public void onEnable() {
        this.reloadMainConfig();
        this.database = Database.init(this);
        Path stockfishPath = new StockfishProvider(this, this.getDataFolder().toPath().resolve("engines")).engine(this.config.stockfishEngine());
        this.boardManager = new BoardManager(this, stockfishPath);
        this.boardManager.load();
        new Commands(this).register();
        new Metrics((Plugin)this, 17745);
    }

    public void onDisable() {
        if (this.boardManager != null) {
            this.boardManager.close();
        }
        while (!this.shutdownTasks.isEmpty()) {
            this.shutdownTasks.poll().run();
        }
        if (this.database != null) {
            this.database.close();
        }
    }

    public BoardManager boardManager() {
        return this.boardManager;
    }

    public MainConfig config() {
        return this.config;
    }

    public Database database() {
        return this.database;
    }

    public void reloadMainConfig() {
        this.config = this.loadConfig();
        this.saveConfig(this.config);
    }

    private MainConfig loadConfig() {
        return ConfigHelper.loadConfig(MainConfig.class, this.configFile());
    }

    private void saveConfig(MainConfig config) {
        ConfigHelper.saveConfig(this.configFile(), config);
    }

    private Path configFile() {
        return this.getDataFolder().toPath().resolve("config.yml");
    }

    public Deque<Runnable> shutdownTasks() {
        return this.shutdownTasks;
    }
}

