/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.BoardManager;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.PieceHandler;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.CardinalDirection;
import xyz.jpenilla.chesscraft.data.Fen;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;
import xyz.jpenilla.chesscraft.util.SteppedAnimation;

public final class ChessBoard {
    private final Vec3i loc;
    private final CardinalDirection facing;
    private final Sound moveSound;
    private final BoardManager.BoardData.AutoCpuGameSettings autoCpuGame;
    private final int scale;
    private final String name;
    private final ChessCraft plugin;
    private final NamespacedKey worldKey;
    private final Path stockfishPath;
    private final PieceHandler pieceHandler;
    private final List<? extends BoardDisplaySettings<?>> displays;
    private @Nullable ChessGame game;
    private final SteppedAnimation.SequentialExecutor animationExecutor;

    public ChessBoard(ChessCraft plugin, String name, Vec3i loc, CardinalDirection facing, int scale, NamespacedKey world, List<? extends BoardDisplaySettings<?>> displays, Path stockfishPath, BoardManager.BoardData.AutoCpuGameSettings autoCpuGame, Sound moveSound) {
        this.plugin = plugin;
        this.animationExecutor = new SteppedAnimation.SequentialExecutor(plugin);
        this.name = name;
        this.loc = loc;
        this.facing = facing;
        this.moveSound = moveSound;
        if (scale < 1) {
            throw new IllegalArgumentException("Scale cannot be less than 1.");
        }
        this.scale = scale;
        this.worldKey = world;
        this.displays = displays;
        this.stockfishPath = stockfishPath;
        this.autoCpuGame = autoCpuGame;
        this.pieceHandler = plugin.config().pieces().createHandler(plugin);
    }

    public SteppedAnimation.SequentialExecutor animationExecutor() {
        return this.animationExecutor;
    }

    public void cancelCurrentAnimation() {
        this.animationExecutor.clearCurrent();
    }

    public Sound moveSound() {
        return this.moveSound;
    }

    public List<? extends BoardDisplaySettings<?>> displays() {
        return this.displays;
    }

    PieceHandler pieceHandler() {
        return this.pieceHandler;
    }

    Path stockfishPath() {
        return this.stockfishPath;
    }

    public String name() {
        return this.name;
    }

    public Vec3i loc() {
        return this.loc;
    }

    public CardinalDirection facing() {
        return this.facing;
    }

    public int scale() {
        return this.scale;
    }

    public BoardManager.BoardData.AutoCpuGameSettings autoCpuGame() {
        return this.autoCpuGame;
    }

    public Vec3i toWorld(BoardPosition boardPosition) {
        return this.toWorld0(ChessBoard.rotate(boardPosition, this.facing.radians()));
    }

    public Vec3d toWorld(Vec3d boardPosition) {
        return this.toWorld0(ChessBoard.rotate(boardPosition, this.facing.radians()));
    }

    private Vec3i toWorld0(BoardPosition boardPosition) {
        return new Vec3i(this.loc.x() + boardPosition.file() * this.scale, this.loc.y(), this.loc.z() + (boardPosition.rank() - 7) * this.scale);
    }

    private Vec3d toWorld0(Vec3d boardPosition) {
        return new Vec3d((double)this.loc.x() + boardPosition.x() * (double)this.scale, this.loc.y(), (double)this.loc.z() + (boardPosition.z() - 7.0) * (double)this.scale);
    }

    private BoardPosition toBoard(int worldX, int worldZ) {
        BoardPosition pos = this.toBoard0(worldX, worldZ);
        return ChessBoard.rotate(pos, this.facing.negativeRadians());
    }

    private BoardPosition toBoard0(int worldX, int worldZ) {
        return new BoardPosition((7 * this.scale + worldZ - this.loc.z()) / this.scale, (worldX - this.loc.x()) / this.scale);
    }

    private static BoardPosition rotate(BoardPosition pos, double angleRadians) {
        IntIntPair rotated = ChessBoard.rotatePoint(pos.file(), pos.rank(), 3.5, 3.5, angleRadians);
        return new BoardPosition(rotated.secondInt(), rotated.firstInt());
    }

    private static Vec3d rotate(Vec3d pos, double angleRadians) {
        return ChessBoard.rotatePoint(pos.x(), pos.z(), 3.5, 3.5, angleRadians);
    }

    private static IntIntPair rotatePoint(int x, int z, double centerX, double centerZ, double angleRadians) {
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        int nX = (int)Math.round(((double)x - centerX) * cos - ((double)z - centerZ) * sin + centerX);
        int nZ = (int)Math.round(((double)x - centerX) * sin + ((double)z - centerZ) * cos + centerZ);
        return IntIntPair.of((int)nX, (int)nZ);
    }

    private static Vec3d rotatePoint(double x, double z, double centerX, double centerZ, double angleRadians) {
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        double nX = (x - centerX) * cos - (z - centerZ) * sin + centerX;
        double nZ = (x - centerX) * sin + (z - centerZ) * cos + centerZ;
        return new Vec3d(nX, 0.0, nZ);
    }

    public Vec3i toWorld(String notation) {
        return this.toWorld(BoardPosition.fromString(notation));
    }

    public void forEachPosition(Consumer<BoardPosition> consumer) {
        for (int rank = 0; rank < 8; ++rank) {
            for (int file = 0; file < 8; ++file) {
                consumer.accept(new BoardPosition(rank, file));
            }
        }
    }

    public boolean handleInteract(Player player, int x, int y, int z) {
        if (this.hasGame() && this.worldKey.equals((Object)player.getWorld().getKey()) && this.contains(x, y, z)) {
            this.game().handleInteract(player, this.toBoard(x, z));
            return true;
        }
        return false;
    }

    private boolean contains(int x, int y, int z) {
        return x <= this.loc.x() + 7 * this.scale + this.scale - 1 && x >= this.loc.x() && z >= this.loc.z() - 7 * this.scale && z <= this.loc.z() + this.scale - 1 && y >= this.loc.y() - 1 && y <= this.loc.y() + this.scale * 2 - 1;
    }

    public NamespacedKey worldKey() {
        return this.worldKey;
    }

    public boolean hasGame() {
        return this.game != null;
    }

    public ChessGame game() {
        return Objects.requireNonNull(this.game, "No game active");
    }

    public void startCpuGame(int moveDelay, int whiteElo, int blackElo, @Nullable TimeControlSettings timeControl) {
        this.startGame(ChessPlayer.cpu(whiteElo), ChessPlayer.cpu(blackElo), timeControl, moveDelay);
    }

    public void startGame(ChessPlayer white, ChessPlayer black, @Nullable TimeControlSettings timeControl) {
        this.startGame(white, black, timeControl, -1);
    }

    public void startGame(ChessPlayer white, ChessPlayer black, @Nullable TimeControlSettings timeControl, int moveDelay) {
        if (!(!this.autoCpuGame.enabled || this.autoCpuGame.allowPlayerUse || white.isCpu() && black.isCpu())) {
            throw new IllegalStateException("This board is only for CPU games!");
        }
        if (this.game != null) {
            throw new IllegalStateException("Board is occupied");
        }
        this.cancelCurrentAnimation();
        this.game = new ChessGame(this.plugin, this, white, black, timeControl, moveDelay);
        this.game.audience().sendMessage(this.plugin.config().messages().matchStarted(this, white, black));
        if (white.isCpu()) {
            this.game.cpuMove();
        }
    }

    public void resumeGame(GameState state) {
        if (!state.playersOnline()) {
            throw new IllegalStateException();
        }
        if (!(!this.autoCpuGame.enabled || this.autoCpuGame.allowPlayerUse || state.white().isCpu() && state.black().isCpu())) {
            throw new IllegalStateException("This board is only for CPU games!");
        }
        if (this.game != null) {
            throw new IllegalStateException("Board is occupied");
        }
        this.cancelCurrentAnimation();
        this.game = new ChessGame(this.plugin, this, state);
        this.game.audience().sendMessage(this.plugin.config().messages().matchResumed(this, state.white(), state.black()));
        if (state.currentFen().nextMove() == PieceColor.WHITE ? state.whiteCpu() : state.blackCpu()) {
            this.game.cpuMove();
        }
    }

    public void endGame() {
        this.endGame(false, false);
    }

    public void endGameAndWait() {
        this.endGame(false, true);
    }

    public void endGame(boolean removePieces, boolean wait) {
        if (this.game == null) {
            throw new IllegalStateException("No game to end");
        }
        this.game.close(removePieces, wait);
        this.game = null;
    }

    public void applyCheckerboard(Material black, Material white, @Nullable Material border) {
        World world = this.world();
        this.forEachPosition(pos -> {
            Vec3i loc = this.toWorld((BoardPosition)pos);
            Material material = (pos.rank() * 7 + pos.file()) % 2 == 0 ? white : black;
            for (int i = 0; i < this.scale; ++i) {
                for (int h = 0; h < this.scale; ++h) {
                    world.setType(loc.x() + i, loc.y() - 1, loc.z() + h, material);
                }
            }
        });
        if (border == null) {
            return;
        }
        this.applyBorder(world, border);
    }

    private void applyBorder(World world, Material border) {
        int minX = this.loc.x() - 1;
        int maxZ = this.loc.z() + this.scale;
        int minZ = this.loc.z() - this.scale * 7 - 1;
        int maxX = this.loc.x() + this.scale * 8;
        for (int x = minX; x <= maxX; ++x) {
            world.setType(new Location(world, (double)x, (double)(this.loc.y() - 1), (double)minZ), border);
            world.setType(new Location(world, (double)x, (double)(this.loc.y() - 1), (double)maxZ), border);
        }
        for (int z = minZ; z <= maxZ; ++z) {
            world.setType(new Location(world, (double)minX, (double)(this.loc.y() - 1), (double)z), border);
            world.setType(new Location(world, (double)maxX, (double)(this.loc.y() - 1), (double)z), border);
        }
    }

    public World world() {
        return Objects.requireNonNull(this.plugin.getServer().getWorld(this.worldKey), "World '" + String.valueOf(this.worldKey) + "' is not loaded");
    }

    public void reset(boolean clear) {
        if (this.hasGame()) {
            throw new IllegalStateException("Can't reset with an active game");
        }
        if (clear) {
            this.pieceHandler.removeFromWorld(this, this.world());
        } else {
            this.pieceHandler.applyToWorld(this, Fen.STARTING_FEN, this.world());
        }
    }

    public static Piece[][] initBoard() {
        Piece[][] board = new Piece[8][8];
        for (int rank = 0; rank < board.length; ++rank) {
            board[rank] = new Piece[8];
        }
        return board;
    }
}

