/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.config.ConfigHelper;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.CardinalDirection;
import xyz.jpenilla.chesscraft.data.PVPChallenge;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;
import xyz.jpenilla.chesscraft.display.settings.BoardStatusSettings;
import xyz.jpenilla.chesscraft.display.settings.MessageLogSettings;
import xyz.jpenilla.chesscraft.display.settings.PositionLabelSettings;

public final class BoardManager
implements Listener {
    static final NamespacedKey PIECE_KEY = new NamespacedKey("chesscraft", "chess_piece");
    private final ChessCraft plugin;
    private final Path stockfishPath;
    private final Path boardsFile;
    private final Path displaysFile;
    private final Map<String, ChessBoard> boards;
    private final Map<String, BoardDisplaySettings<?>> displays;
    private final Cache<UUID, PVPChallenge> challenges;
    private final Cache<UUID, Object> pauseProposals;
    private @MonotonicNonNull AutoCpuGames autoCpuGames;
    private BukkitTask particleTask;

    public BoardManager(ChessCraft plugin, Path stockfishPath) {
        this.plugin = plugin;
        this.stockfishPath = stockfishPath;
        this.boardsFile = plugin.getDataFolder().toPath().resolve("boards.yml");
        this.boards = new ConcurrentHashMap<String, ChessBoard>();
        this.displaysFile = plugin.getDataFolder().toPath().resolve("displays.yml");
        this.displays = new ConcurrentHashMap();
        this.challenges = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();
        this.pauseProposals = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();
        try {
            Files.createDirectories(this.boardsFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Cache<UUID, PVPChallenge> challenges() {
        return this.challenges;
    }

    public Cache<UUID, Object> pauseProposals() {
        return this.pauseProposals;
    }

    public Collection<ChessBoard> boards() {
        return this.boards.values();
    }

    public Collection<ChessBoard> activeBoards() {
        return this.boards().stream().filter(ChessBoard::hasGame).toList();
    }

    public void createBoard(String name, World world, Vec3i pos, CardinalDirection facing, int scale) {
        ChessBoard board = new ChessBoard(this.plugin, name, pos, facing, scale, world.getKey(), this.displays(this.plugin.config().defaultDisplays()), this.stockfishPath, new BoardData.AutoCpuGameSettings(), BoardData.DEFAULT_SOUND);
        this.boards.put(name, board);
        this.saveBoards();
    }

    public void reload() {
        this.close();
        this.load();
    }

    public void deleteBoard(String board) {
        ChessBoard remove = this.boards.remove(board);
        if (remove == null) {
            throw new IllegalArgumentException(board);
        }
        if (remove.hasGame()) {
            remove.endGame(true, true);
        } else {
            remove.pieceHandler().removeFromWorld(remove, remove.world());
            for (BoardDisplaySettings<?> settings : remove.displays()) {
                settings.remove(settings.getOrCreateState(this.plugin, remove));
            }
        }
        this.saveBoards();
    }

    public ChessBoard board(String name) {
        return this.boards.get(name);
    }

    public void load() {
        this.loadDisplays();
        this.saveDisplays();
        this.loadBoards();
        this.saveBoards();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.particleTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.activeBoards().forEach(board -> board.game().displayParticles()), 0L, 5L);
        this.autoCpuGames = AutoCpuGames.start(this.plugin, this);
    }

    private void loadBoards() {
        Map read = ConfigHelper.loadConfig(new TypeToken<Map<String, BoardData>>(this){}, this.boardsFile, HashMap::new);
        read.forEach((key, data) -> this.boards.put((String)key, new ChessBoard(this.plugin, (String)key, data.position, data.facing, data.scale, data.dimension, this.displays(data.displays), this.stockfishPath, data.autoCpuGame, data.moveSound)));
    }

    private List<? extends BoardDisplaySettings<?>> displays(Collection<String> names) {
        return names.stream().map(this.displays::get).filter(Objects::nonNull).toList();
    }

    public void close() {
        this.autoCpuGames.close();
        this.autoCpuGames = null;
        this.particleTask.cancel();
        this.particleTask = null;
        HandlerList.unregisterAll((Listener)this);
        this.boards.forEach((name, board) -> {
            if (board.hasGame()) {
                if (board.game().cpuVsCpu()) {
                    ChessGame game = board.game();
                    board.endGameAndWait();
                    game.audience().sendMessage(this.plugin.config().messages().matchCancelled());
                } else {
                    this.pauseMatch((ChessBoard)board);
                }
            }
            board.animationExecutor().cancel();
        });
        this.boards.clear();
        this.displays.clear();
    }

    private void saveBoards() {
        Map<String, BoardData> collect = this.boards.values().stream().map(b -> Map.entry(b.name(), new BoardData(b.worldKey(), b.loc(), b.facing(), b.scale(), b.displays().stream().map(this::nameOf).filter(Objects::nonNull).toList(), b.autoCpuGame()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ConfigHelper.saveConfig(this.boardsFile, new TypeToken<Map<String, BoardData>>(this){}, collect);
    }

    private @Nullable String nameOf(BoardDisplaySettings<?> display) {
        return this.displays.entrySet().stream().filter(it -> it.getValue() == display).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private void loadDisplays() {
        Map read = ConfigHelper.loadConfig(new TypeToken<Map<String, BoardDisplaySettings<?>>>(this){}, this.displaysFile, () -> Map.of("log", new MessageLogSettings(), "status", new BoardStatusSettings(), "position-labels", new PositionLabelSettings()));
        this.displays.putAll(read);
    }

    private void saveDisplays() {
        ConfigHelper.saveConfig(this.displaysFile, new TypeToken<Map<String, BoardDisplaySettings<?>>>(this){}, this.displays);
    }

    public void pauseMatch(ChessBoard board) {
        ChessGame game = board.game();
        board.endGameAndWait();
        GameState state = game.snapshotState(null);
        this.plugin.database().saveMatchAsync(state, false);
        game.audience().sendMessage(this.plugin.config().messages().pausedMatch());
    }

    public boolean inGame(Player player) {
        return this.boards.values().stream().anyMatch(board -> board.hasGame() && board.game().hasPlayer(player));
    }

    @EventHandler
    public void interact(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block clicked = Objects.requireNonNull(event.getClickedBlock());
        for (ChessBoard board : this.activeBoards()) {
            if (!board.handleInteract(event.getPlayer(), clicked.getX(), clicked.getY(), clicked.getZ())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void interact(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().getType() != EntityType.ARMOR_STAND && event.getRightClicked().getType() != EntityType.INTERACTION) {
            return;
        }
        if (!event.getRightClicked().getPersistentDataContainer().has(PIECE_KEY)) {
            return;
        }
        Location loc = event.getRightClicked().getLocation();
        this.interact((Cancellable)event, loc, event.getPlayer());
    }

    private void interact(Cancellable event, Location loc, Player player) {
        for (ChessBoard board : this.activeBoards()) {
            if (!board.handleInteract(player, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void quit(PlayerQuitEvent event) {
        for (ChessBoard board : this.activeBoards()) {
            ChessGame game = board.game();
            if (!game.hasPlayer(event.getPlayer())) continue;
            game.forfeit(game.color(ChessPlayer.player(event.getPlayer())));
        }
        for (PVPChallenge challenge : List.copyOf(this.challenges.asMap().values())) {
            if (!challenge.challenger().equals((Object)event.getPlayer()) && !challenge.player().equals((Object)event.getPlayer())) continue;
            this.challenges.invalidate((Object)challenge.player().getUniqueId());
        }
        this.pauseProposals.invalidate((Object)event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void damage(HangingBreakEvent event) {
        if (!event.getEntity().getPersistentDataContainer().has(PIECE_KEY)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void rotate(PlayerItemFrameChangeEvent event) {
        if (event.getAction() != PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE || !event.getItemFrame().getPersistentDataContainer().has(PIECE_KEY)) {
            return;
        }
        event.setCancelled(true);
        this.interact((Cancellable)event, event.getItemFrame().getLocation().toBlockLocation(), event.getPlayer());
    }

    @EventHandler
    public void damage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof ArmorStand) && !(event.getEntity() instanceof ItemFrame)) {
            return;
        }
        @Nullable String data = (String)event.getEntity().getPersistentDataContainer().get(PIECE_KEY, PersistentDataType.STRING);
        if (data == null) {
            return;
        }
        event.setCancelled(true);
    }

    public void delayAutoCpu(ChessBoard board) {
        this.autoCpuGames.delay(board);
    }

    @ConfigSerializable
    public static final class BoardData {
        public static final net.kyori.adventure.sound.Sound DEFAULT_SOUND = (net.kyori.adventure.sound.Sound)net.kyori.adventure.sound.Sound.sound().type((Sound.Type)Sound.ITEM_AXE_STRIP).seed(-5784237514302714804L).source(Sound.Source.BLOCK).build();
        private NamespacedKey dimension = NamespacedKey.minecraft((String)"overworld");
        private Vec3i position = new Vec3i(0, 0, 0);
        private CardinalDirection facing = CardinalDirection.NORTH;
        private int scale = 1;
        private net.kyori.adventure.sound.Sound moveSound = DEFAULT_SOUND;
        private List<String> displays = List.of();
        private AutoCpuGameSettings autoCpuGame = new AutoCpuGameSettings();

        BoardData() {
        }

        BoardData(NamespacedKey dimension, Vec3i position, CardinalDirection facing, int scale, List<String> displays, AutoCpuGameSettings autoCpuGame) {
            this.dimension = dimension;
            this.position = position;
            this.facing = facing;
            this.scale = scale;
            this.displays = displays;
            this.autoCpuGame = autoCpuGame;
        }

        @ConfigSerializable
        public static final class AutoCpuGameSettings {
            public boolean enabled = false;
            public double range = 25.0;
            public boolean allowPlayerUse = false;
            public int moveDelay = 4;
            public int whiteElo = 1800;
            public int blackElo = 2200;

            public boolean cpuGamesOnly() {
                return this.enabled && !this.allowPlayerUse;
            }
        }
    }

    private static final class AutoCpuGames {
        private final Cache<String, Object> delay = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(10L)).build();
        private final ConcurrentHashMap<String, Runnable> taskMap = new ConcurrentHashMap();
        private final BukkitTask mainTask;
        private final BukkitTask asyncTask;

        static AutoCpuGames start(ChessCraft plugin, BoardManager boardManager) {
            return new AutoCpuGames(plugin, boardManager);
        }

        private AutoCpuGames(ChessCraft plugin, BoardManager boardManager) {
            this.mainTask = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, () -> {
                for (Map.Entry<String, ChessBoard> e : boardManager.boards.entrySet()) {
                    ChessBoard board = e.getValue();
                    if (!board.autoCpuGame().enabled) continue;
                    String name = e.getKey();
                    Collection nearby = board.toWorld(new BoardPosition(3, 3)).toLocation(board.world()).getNearbyPlayers(board.autoCpuGame().range);
                    this.taskMap.put(name, () -> {
                        if (!nearby.isEmpty() && board.hasGame()) {
                            this.delay.put((Object)board.name(), new Object());
                        } else if (nearby.isEmpty() && board.hasGame()) {
                            ChessGame game = board.game();
                            if (game.cpuVsCpu()) {
                                board.endGameAndWait();
                                game.audience().sendMessage(plugin.config().messages().matchCancelled());
                                this.delay.invalidate((Object)board.name());
                            }
                        } else if (!nearby.isEmpty() && this.delay.getIfPresent((Object)board.name()) == null) {
                            board.startCpuGame(board.autoCpuGame().moveDelay, board.autoCpuGame().whiteElo, board.autoCpuGame().blackElo, null);
                        }
                    });
                }
            }, 20L, 20L);
            Semaphore permit = new Semaphore(1);
            this.asyncTask = plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
                if (!permit.tryAcquire()) {
                    return;
                }
                try {
                    for (String name : boardManager.boards.keySet()) {
                        @Nullable Runnable task = this.taskMap.remove(name);
                        if (task == null) continue;
                        task.run();
                    }
                }
                finally {
                    permit.release();
                }
            }, 20L, 5L);
        }

        void close() {
            this.mainTask.cancel();
            this.asyncTask.cancel();
        }

        void delay(ChessBoard board) {
            this.delay.put((Object)board.name(), new Object());
        }
    }
}

