/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.profile;

import com.lishid.openinv.util.profile.Profile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProfileStore {
    public void addProfile(@NotNull Profile var1);

    public void setup() throws Exception;

    public void shutdown() throws Exception;

    public void tryImport() throws Exception;

    @Nullable
    public Profile getProfileExact(@NotNull String var1);

    @Nullable
    public Profile getProfileInexact(@NotNull String var1);

    public static void warnMainThread(@NotNull Logger logger) {
        if (!Bukkit.getServer().isPrimaryThread()) {
            return;
        }
        Throwable throwable = new Throwable("Current stack trace");
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length < 2) {
            return;
        }
        StackTraceElement caller = stackTrace[1];
        logger.warning(() -> String.format("Call to %s#%s made on the main thread!", caller.getClassName(), caller.getMethodName()));
        logger.warning("This can cause the server to hang, potentially severely.");
        logger.log(Level.WARNING, "Current stack trace", throwable);
    }
}

