/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class TabCompleter {
    @NotNull
    public static @Unmodifiable List<String> completeInteger(@NotNull String argument) {
        if (!argument.isEmpty()) {
            try {
                Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                return List.of();
            }
        }
        ArrayList<CallSite> completions = new ArrayList<CallSite>(10);
        for (int i = 0; i < 10; ++i) {
            completions.add((CallSite)((Object)(argument + i)));
        }
        return Collections.unmodifiableList(completions);
    }

    @NotNull
    public static List<String> completeEnum(@NotNull String argument, @NotNull Class<? extends Enum<?>> enumClazz) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (Enum<?> enumConstant : enumClazz.getEnumConstants()) {
            String name = enumConstant.name().toLowerCase(Locale.ENGLISH);
            if (!name.startsWith(argument)) continue;
            completions.add(name);
        }
        return completions;
    }

    @NotNull
    public static List<String> completeString(@NotNull String argument, @NotNull @NotNull String @NotNull [] options) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (String option : options) {
            if (!option.startsWith(argument)) continue;
            completions.add(option);
        }
        return completions;
    }

    public static List<String> completeOnlinePlayer(@Nullable CommandSender sender, @NotNull String argument) {
        Player player;
        ArrayList<String> completions = new ArrayList<String>();
        Player senderPlayer = sender instanceof Player ? (player = (Player)sender) : null;
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (senderPlayer != null && !senderPlayer.canSee(player2) || !StringUtil.startsWithIgnoreCase((String)player2.getName(), (String)argument)) continue;
            completions.add(player2.getName());
        }
        return completions;
    }

    public static <T> List<String> completeObject(@NotNull String argument, @NotNull @NotNull Function<@NotNull T, @NotNull String> converter, @NotNull @NotNull T @NotNull [] options) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (T option : options) {
            String optionString = converter.apply(option).toLowerCase(Locale.ENGLISH);
            if (!optionString.startsWith(argument)) continue;
            completions.add(optionString);
        }
        return completions;
    }

    private TabCompleter() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }
}

