/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import java.util.function.Predicate;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchHelper {
    public static boolean findMatch(@NotNull Inventory inventory, @NotNull @NotNull Predicate<@NotNull ItemStack> predicate) {
        for (ItemStack content : inventory.getContents()) {
            if (!SearchHelper.findMatch(content, predicate)) continue;
            return true;
        }
        return false;
    }

    private static boolean findMatch(@Nullable ItemStack itemStack, @NotNull @NotNull Predicate<@NotNull ItemStack> predicate) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return false;
        }
        if (predicate.test(itemStack)) {
            return true;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockState blockState;
            BlockStateMeta stateMeta = (BlockStateMeta)meta;
            if (!stateMeta.hasBlockState() || !((blockState = stateMeta.getBlockState()) instanceof InventoryHolder)) {
                return false;
            }
            InventoryHolder holder = (InventoryHolder)blockState;
            Inventory inventory = holder.getInventory();
            return SearchHelper.findMatch(inventory, predicate);
        }
        if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            for (ItemStack subStack : bundleMeta.getItems()) {
                if (!SearchHelper.findMatch(subStack, predicate)) continue;
                return true;
            }
        }
        return false;
    }

    private SearchHelper() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }
}

