/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.errorprone.annotations.Keep;
import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.InternalAccessor;
import com.lishid.openinv.util.InventoryManager;
import com.lishid.openinv.util.StringMetric;
import com.lishid.openinv.util.config.Config;
import com.lishid.openinv.util.profile.OfflinePlayerProfileStore;
import com.lishid.openinv.util.profile.Profile;
import com.lishid.openinv.util.profile.ProfileStore;
import com.lishid.openinv.util.profile.sqlite.SqliteProfileStore;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerLoader
implements Listener {
    @NotNull
    private final OpenInv plugin;
    @NotNull
    private final Config config;
    @NotNull
    private final InventoryManager inventoryManager;
    @NotNull
    private final InternalAccessor internalAccessor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Cache<String, Profile> lookupCache;
    @NotNull
    private ProfileStore profileStore;

    public PlayerLoader(@NotNull OpenInv plugin, @NotNull Config config, @NotNull InventoryManager inventoryManager, @NotNull InternalAccessor internalAccessor, @NotNull Logger logger) {
        this.plugin = plugin;
        this.config = config;
        this.inventoryManager = inventoryManager;
        this.internalAccessor = internalAccessor;
        try {
            SqliteProfileStore sqliteStore = new SqliteProfileStore(plugin);
            sqliteStore.setup();
            sqliteStore.tryImport();
            this.profileStore = sqliteStore;
        }
        catch (Exception e) {
            this.profileStore = new OfflinePlayerProfileStore(logger);
        }
        this.logger = logger;
        this.lookupCache = CacheBuilder.newBuilder().maximumSize(20L).build();
    }

    @NotNull
    public ProfileStore getProfileStore() {
        return this.profileStore;
    }

    public void setProfileStore(@NotNull ProfileStore profileStore) {
        this.plugin.getLogger().log(Level.INFO, () -> "Setting profile store implementation to " + profileStore.getClass().getName());
        this.profileStore = profileStore;
    }

    @Nullable
    public Player load(@NotNull OfflinePlayer offline) {
        Player player = offline.getPlayer();
        if (player != null) {
            return player;
        }
        if (this.config.isOfflineDisabled() || !this.internalAccessor.isSupported()) {
            return null;
        }
        player = this.inventoryManager.getLoadedPlayer(offline.getUniqueId());
        if (player != null) {
            return player;
        }
        if (Bukkit.isPrimaryThread()) {
            return this.internalAccessor.getPlayerDataManager().loadPlayer(offline);
        }
        CompletableFuture future = new CompletableFuture();
        this.plugin.getScheduler().runTask(() -> future.complete(this.internalAccessor.getPlayerDataManager().loadPlayer(offline)));
        try {
            player = (Player)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
        return player;
    }

    @Nullable
    public OfflinePlayer matchExact(@NotNull String name) {
        try {
            UUID uuid = UUID.fromString(name);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.hasPlayedBefore() || player.isOnline()) {
                return player;
            }
            return null;
        }
        catch (IllegalArgumentException uuid) {
            Player player = Bukkit.getServer().getPlayerExact(name);
            if (player != null) {
                return player;
            }
            Profile cachedResult = (Profile)this.lookupCache.getIfPresent((Object)name);
            if (cachedResult != null) {
                player = Bukkit.getOfflinePlayer((UUID)cachedResult.id());
                if (player.hasPlayedBefore() || player.isOnline()) {
                    return player;
                }
                return null;
            }
            Profile profile = this.profileStore.getProfileExact(name);
            if (profile == null) {
                return null;
            }
            player = Bukkit.getOfflinePlayer((UUID)profile.id());
            if (player.hasPlayedBefore()) {
                this.lookupCache.put((Object)name, (Object)profile);
                return player;
            }
            return null;
        }
    }

    @Nullable
    public OfflinePlayer match(@NotNull String name) {
        OfflinePlayer player = this.matchExact(name);
        if (player != null) {
            return player;
        }
        player = Bukkit.getServer().getPlayer(name);
        if (player != null) {
            return player;
        }
        Profile profile = this.getProfileStore().getProfileInexact(name);
        if (profile == null) {
            return null;
        }
        player = Bukkit.getOfflinePlayer((UUID)profile.id());
        if (player.hasPlayedBefore()) {
            this.lookupCache.put((Object)name, (Object)profile);
            return player;
        }
        return null;
    }

    @Keep
    @EventHandler
    private void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        this.plugin.getScheduler().runTaskLaterAsynchronously(() -> this.updateMatches(event), 7L);
    }

    private void updateMatches(@NotNull PlayerJoinEvent event) {
        this.profileStore.addProfile(new Profile(event.getPlayer()));
        if (event.getPlayer().hasPlayedBefore() || this.lookupCache.size() == 0L) {
            return;
        }
        String name = event.getPlayer().getName();
        this.lookupCache.invalidate((Object)name);
        Iterator iterator = this.lookupCache.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String oldMatch = ((Profile)entry.getValue()).name();
            String lookup = (String)entry.getKey();
            float oldMatchScore = StringMetric.compareJaroWinkler(lookup, oldMatch);
            float newMatchScore = StringMetric.compareJaroWinkler(lookup, name);
            if (!(newMatchScore > oldMatchScore)) continue;
            iterator.remove();
        }
    }
}

