/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.spi.LocationAwareLogger;

public class JulLoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger {
    private final Logger wrapped;

    public JulLoggerAdapter(Logger wrapped) {
        this.wrapped = wrapped;
        this.name = wrapped.getName();
    }

    protected String getFullyQualifiedCallerName() {
        return JulLoggerAdapter.class.getName();
    }

    protected void handleNormalizedLoggingCall(org.slf4j.event.Level slf4jLevel, Marker marker, String msg, Object[] args, Throwable thrown) {
        Level level = this.fromSlf4jLevel(slf4jLevel);
        if (this.wrapped.isLoggable(level)) {
            this.normalizedLog(this.getFullyQualifiedCallerName(), level, msg, args, thrown);
        }
    }

    private void normalizedLog(String fqcn, Level level, String msg, Object[] args, Throwable thrown) {
        String formatted = MessageFormatter.basicArrayFormat((String)msg, (Object[])args);
        LogRecord logRecord = new LogRecord(level, formatted);
        logRecord.setLoggerName(this.getName());
        logRecord.setThrown(thrown);
        this.addSource(fqcn, logRecord);
        this.wrapped.log(logRecord);
    }

    private void addSource(String fqcn, LogRecord logRecord) {
        int maxElements;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        int lastIgnored = maxElements = 12;
        for (int i = 2; i < maxElements; ++i) {
            if (!this.isIgnored(trace[i].getClassName(), fqcn)) continue;
            lastIgnored = i;
        }
        if (lastIgnored < maxElements - 1) {
            StackTraceElement caller = trace[lastIgnored + 1];
            logRecord.setSourceClassName(caller.getClassName());
            logRecord.setSourceMethodName(caller.getMethodName());
        }
    }

    private boolean isIgnored(String className, String fqcn) {
        if (className.equals(fqcn)) {
            return true;
        }
        if (className.startsWith("org.slf4j.")) {
            return true;
        }
        return className.equals(this.getFullyQualifiedCallerName());
    }

    public void log(Marker marker, String callerFqn, int levelInt, String msg, Object[] args, Throwable thrown) {
        Level level = this.fromSlf4jLevel(org.slf4j.event.Level.intToLevel((int)levelInt));
        if (!this.wrapped.isLoggable(level)) {
            return;
        }
        NormalizedParameters params = NormalizedParameters.normalize((String)msg, (Object[])args, (Throwable)thrown);
        this.normalizedLog(callerFqn, level, params.getMessage(), params.getArguments(), params.getThrowable());
    }

    private Level fromSlf4jLevel(org.slf4j.event.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case org.slf4j.event.Level.TRACE -> Level.FINEST;
            case org.slf4j.event.Level.DEBUG -> Level.FINE;
            case org.slf4j.event.Level.INFO -> Level.INFO;
            case org.slf4j.event.Level.WARN -> Level.WARNING;
            case org.slf4j.event.Level.ERROR -> Level.SEVERE;
        };
    }

    public boolean isTraceEnabled() {
        return this.wrapped.isLoggable(Level.FINEST);
    }

    public boolean isDebugEnabled() {
        return this.wrapped.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.wrapped.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.wrapped.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.wrapped.isLoggable(Level.SEVERE);
    }
}

