/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.config.Config;
import java.util.Locale;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AccessEqualMode {
    DENY,
    ALLOW,
    VIEW;


    @NotNull
    public static AccessEqualMode of(@Nullable String value) {
        if (value == null) {
            return VIEW;
        }
        return switch (value.toLowerCase(Locale.ENGLISH)) {
            case "deny", "false" -> DENY;
            case "allow", "true" -> ALLOW;
            default -> VIEW;
        };
    }

    @NotNull
    public static AccessEqualMode getByPerm(@NotNull Permissible permissible, @NotNull Config config) {
        if (Permissions.ACCESS_EQUAL_EDIT.hasPermission(permissible)) {
            return ALLOW;
        }
        if (Permissions.ACCESS_EQUAL_VIEW.hasPermission(permissible)) {
            return VIEW;
        }
        if (Permissions.ACCESS_EQUAL_DENY.hasPermission(permissible)) {
            return DENY;
        }
        return config.getAccessEqualMode();
    }
}

