/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.player;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.reobf.container.OpenEnderChest;
import com.lishid.openinv.internal.reobf.container.OpenInventory;
import com.lishid.openinv.internal.reobf.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.reobf.player.OpenPlayer;
import com.lishid.openinv.util.JulLoggerAdapter;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.logging.Level;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerManager
implements com.lishid.openinv.internal.PlayerManager {
    @NotNull
    private final java.util.logging.Logger logger;
    @Nullable
    private Field bukkitEntity;

    public PlayerManager(@NotNull java.util.logging.Logger logger) {
        this.logger = logger;
        try {
            this.bukkitEntity = Entity.class.getDeclaredField("bukkitEntity");
        }
        catch (NoSuchFieldException e) {
            logger.warning("Unable to obtain field to inject custom save process - certain player data may be lost when saving!");
            logger.log(Level.WARNING, e.getMessage(), e);
            this.bukkitEntity = null;
        }
    }

    @NotNull
    public static EntityPlayer getHandle(Player player) {
        if (player instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)player;
            return craftPlayer.getHandle();
        }
        Server server = player.getServer();
        EntityPlayer nmsPlayer = null;
        if (server instanceof CraftServer) {
            CraftServer craftServer = (CraftServer)server;
            nmsPlayer = craftServer.getHandle().b(player.getUniqueId());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from Player implementation " + player.getClass().getName());
        }
        return nmsPlayer;
    }

    @Override
    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        Server server = Bukkit.getServer();
        if (!(server instanceof CraftServer)) {
            return null;
        }
        CraftServer craftServer = (CraftServer)server;
        DedicatedServer server2 = craftServer.getServer();
        WorldServer worldServer = server2.a(World.h);
        if (worldServer == null) {
            return null;
        }
        EntityPlayer entity = this.createNewPlayer((MinecraftServer)server2, worldServer, offline);
        entity.U().a();
        if (this.loadData(entity)) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @NotNull
    private EntityPlayer createNewPlayer(@NotNull MinecraftServer server, @NotNull WorldServer worldServer, @NotNull OfflinePlayer offline) {
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        ClientInformation dummyInfo = new ClientInformation("en_us", 1, EnumChatVisibility.c, false, 0, EntityPlayer.l, true, false, ParticleStatus.c);
        EntityPlayer entity = new EntityPlayer(server, worldServer, profile, dummyInfo);
        try {
            this.injectPlayer(entity);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
        }
        return entity;
    }

    boolean loadData(@NotNull EntityPlayer player) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(player.es(), (Logger)new JulLoggerAdapter(this.logger));){
            NBTTagCompound loadedData = player.cL.aj().s.a(player.gJ()).orElse(null);
            if (loadedData == null) {
                boolean bl = false;
                return bl;
            }
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)player.eo(), (NBTTagCompound)loadedData);
            player.d(valueInput);
        }
        return true;
    }

    private void injectPlayer(EntityPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.cL.server, player, this));
    }

    @Override
    @NotNull
    public Player inject(@NotNull Player player) {
        try {
            EntityPlayer nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof OpenPlayer) {
                OpenPlayer openPlayer = (OpenPlayer)craftPlayer;
                return openPlayer;
            }
            this.injectPlayer(nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull Player bukkitPlayer, @NotNull ISpecialInventory inventory, boolean viewOnly) {
        IChatBaseComponent title;
        OpenChestMenu<?> menu;
        EntityPlayer player = PlayerManager.getHandle(bukkitPlayer);
        if (!OpenPlayer.isConnected(player.g)) {
            return null;
        }
        if (inventory instanceof OpenInventory) {
            OpenInventory playerInv = (OpenInventory)inventory;
            menu = playerInv.createMenu((EntityHuman)player, player.nextContainerCounter(), viewOnly);
            title = playerInv.getTitle(player, menu);
        } else if (inventory instanceof OpenEnderChest) {
            OpenEnderChest enderChest = (OpenEnderChest)inventory;
            menu = enderChest.createMenu((EntityHuman)player, player.nextContainerCounter(), viewOnly);
            title = enderChest.getTitle(menu);
        } else {
            return null;
        }
        if (menu == null) {
            return null;
        }
        menu.setTitle(title);
        Container opened = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)player, menu, (boolean)false);
        if (opened == null) {
            return null;
        }
        player.cn = opened;
        player.g.b((Packet)new PacketPlayOutOpenWindow(opened.l, opened.a(), opened.getTitle()));
        player.a(opened);
        return opened.getBukkitView();
    }
}

