/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.player;

import com.lishid.openinv.event.OpenEvents;
import com.lishid.openinv.internal.reobf.player.PlayerManager;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

public class OpenPlayer
extends CraftPlayer {
    protected static final @Unmodifiable Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "Passengers", "warden_spawn_tracker", "entered_nether_pos", "enteredNetherPosition", "respawn", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "raid_omen_position", "ender_pearls", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "current_explosion_impact_pos", "active_effects", "sleeping_pos", "SleepingX", "SleepingY", "SleepingZ", "Brain", "last_hurt_by_player", "last_hurt_by_player_memory_time", "last_hurt_by_mob", "ticks_since_last_hurt_by_mob", "equipment", "locator_bar_icon");
    private final PlayerManager manager;

    protected OpenPlayer(CraftServer server, EntityPlayer entity, PlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData(this.getHandle());
    }

    public void saveData() {
        if (OpenEvents.saveCancelled((Player)this)) {
            return;
        }
        EntityPlayer player = this.getHandle();
        Logger logger = LogUtils.getLogger();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(player.es(), logger);){
            WorldNBTStorage worldNBTStorage = this.server.getServer().bA().s;
            NBTTagCompound oldData = this.isOnline() ? null : (NBTTagCompound)worldNBTStorage.a(player.gJ()).orElse(null);
            NBTTagCompound playerData = this.getWritableTag(oldData);
            TagValueOutput valueOutput = TagValueOutput.a((ProblemReporter)scopedCollector, (HolderLookup.a)player.eo());
            Field tagValueOutputOutput = TagValueOutput.class.getDeclaredField("c");
            tagValueOutputOutput.setAccessible(true);
            NBTTagCompound newPlayerData = (NBTTagCompound)tagValueOutputOutput.get(valueOutput);
            newPlayerData.a(playerData);
            playerData = newPlayerData;
            player.d((ValueOutput)valueOutput);
            if (oldData != null) {
                this.revertSpecialValues(playerData, oldData);
            }
            Path playerDataDir = worldNBTStorage.getPlayerDir().toPath();
            Path tempFile = Files.createTempFile(playerDataDir, player.cZ() + "-", ".dat", new FileAttribute[0]);
            NBTCompressedStreamTools.a((NBTTagCompound)playerData, (Path)tempFile);
            Path dataFile = playerDataDir.resolve(player.cZ() + ".dat");
            Path backupFile = playerDataDir.resolve(player.cZ() + ".dat_old");
            SystemUtils.a((Path)dataFile, (Path)tempFile, (Path)backupFile);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.da(), (Object)e);
        }
    }

    @Contract(value="null -> new")
    @NotNull
    protected NBTTagCompound getWritableTag(@Nullable NBTTagCompound oldData) {
        if (oldData == null) {
            return new NBTTagCompound();
        }
        oldData = oldData.l();
        oldData.e().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit") || key.startsWith("Paper") && key.length() > 5);
        return oldData;
    }

    protected void revertSpecialValues(@NotNull NBTTagCompound newData, @NotNull NBTTagCompound oldData) {
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", NBTNumber.class);
    }

    private <T extends NBTBase> void copyValue(@NotNull NBTTagCompound source, @NotNull NBTTagCompound target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        NBTTagCompound oldContainer = this.getTag(source, container, NBTTagCompound.class);
        NBTTagCompound newContainer = this.getTag(target, container, NBTTagCompound.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends NBTBase> T getTag(@Nullable NBTTagCompound container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        NBTBase value = container.a(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((NBTBase)dataType.cast(value));
    }

    private <T extends NBTBase> void setTag(@NotNull NBTTagCompound container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            container.r(key);
        } else {
            container.a(key, data);
        }
    }

    public static boolean isConnected(@Nullable PlayerConnection connection) {
        return connection != null && !connection.isDisconnected();
    }
}

