/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.player;

import com.lishid.openinv.event.OpenEvents;
import com.lishid.openinv.internal.reobf.player.PlayerManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class BaseOpenPlayer
extends CraftPlayer {
    protected static final @Unmodifiable Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "data", "Passengers", "warden_spawn_tracker", "entered_nether_pos", "enteredNetherPosition", "respawn", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "raid_omen_position", "ender_pearls", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "current_explosion_impact_pos", "active_effects", "sleeping_pos", "SleepingX", "SleepingY", "SleepingZ", "Brain", "last_hurt_by_player", "last_hurt_by_player_memory_time", "last_hurt_by_mob", "ticks_since_last_hurt_by_mob", "equipment", "locator_bar_icon");
    private final PlayerManager manager;

    protected BaseOpenPlayer(CraftServer server, EntityPlayer entity, PlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData((MinecraftServer)this.server.getServer(), this.getHandle());
    }

    public void saveData() {
        if (OpenEvents.saveCancelled((Player)this)) {
            return;
        }
        this.trySave(this.getHandle());
    }

    protected abstract void trySave(EntityPlayer var1);

    protected void saveSafe(@NotNull EntityPlayer player, @Nullable NBTTagCompound oldData, @NotNull NBTTagCompound playerData, @NotNull WorldNBTStorage worldNbtStorage) throws IOException {
        this.revertSpecialValues(playerData, oldData);
        Path playerDataDir = worldNbtStorage.getPlayerDir().toPath();
        Path tempFile = Files.createTempFile(playerDataDir, player.cZ() + "-", ".dat", new FileAttribute[0]);
        NBTCompressedStreamTools.a((NBTTagCompound)playerData, (Path)tempFile);
        Path dataFile = playerDataDir.resolve(player.cZ() + ".dat");
        Path backupFile = playerDataDir.resolve(player.cZ() + ".dat_old");
        this.safeReplaceFile(dataFile, tempFile, backupFile);
    }

    protected void safeReplaceFile(@NotNull Path dataFile, @NotNull Path tempFile, @NotNull Path backupFile) {
        SystemUtils.a((Path)dataFile, (Path)tempFile, (Path)backupFile);
    }

    @Contract(value="null -> new")
    @NotNull
    protected NBTTagCompound getWritableTag(@Nullable NBTTagCompound oldData) {
        if (oldData == null) {
            return new NBTTagCompound();
        }
        oldData = oldData.l();
        oldData.e().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit") || key.startsWith("Paper") && key.length() > 5);
        return oldData;
    }

    protected void revertSpecialValues(@NotNull NBTTagCompound newData, @Nullable NBTTagCompound oldData) {
        if (oldData == null) {
            return;
        }
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", NBTNumber.class);
    }

    private <T extends NBTBase> void copyValue(@NotNull NBTTagCompound source, @NotNull NBTTagCompound target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        NBTTagCompound oldContainer = this.getTag(source, container, NBTTagCompound.class);
        NBTTagCompound newContainer = this.getTag(target, container, NBTTagCompound.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends NBTBase> T getTag(@Nullable NBTTagCompound container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        NBTBase value = container.a(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((NBTBase)dataType.cast(value));
    }

    private <T extends NBTBase> void setTag(@NotNull NBTTagCompound container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            this.remove(container, key);
        } else {
            container.a(key, data);
        }
    }

    protected abstract void remove(@NotNull NBTTagCompound var1, @NotNull String var2);

    public static boolean isConnected(@Nullable PlayerConnection connection) {
        return connection != null && !connection.isDisconnected();
    }
}

