/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.slot.placeholder;

import com.lishid.openinv.internal.reobf.container.slot.placeholder.Placeholders;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlaceholderLoaderBase {
    public void load(@Nullable ConfigurationSection section) throws Exception {
        Placeholders.craftingOutput = this.parse(section, "crafting-output", this.defaultCraftingOutput());
        Placeholders.cursor = this.parse(section, "cursor", this.defaultCursor());
        Placeholders.drop = this.parse(section, "drop", this.defaultDrop());
        Placeholders.emptyHelmet = this.parse(section, "empty-helmet", this.getEmptyArmor((IMaterial)Items.re));
        Placeholders.emptyChestplate = this.parse(section, "empty-chestplate", this.getEmptyArmor((IMaterial)Items.rf));
        Placeholders.emptyLeggings = this.parse(section, "empty-leggings", this.getEmptyArmor((IMaterial)Items.rg));
        Placeholders.emptyBoots = this.parse(section, "empty-boots", this.getEmptyArmor((IMaterial)Items.rh));
        Placeholders.emptyOffHand = this.parse(section, "empty-off-hand", this.defaultShield());
        Placeholders.notSlot = this.parse(section, "not-a-slot", this.defaultNotSlot());
        Placeholders.blockedOffline = this.parse(section, "blocked.offline", this.defaultBlockedOffline());
        for (EnumGamemode type : EnumGamemode.values()) {
            ItemStack typeItem = new ItemStack((IMaterial)Items.iu);
            typeItem.b(DataComponents.k, (Object)IChatBaseComponent.c((String)"options.narrator.notavailable").f(" - ").b(type.e()));
            Placeholders.BLOCKED_GAME_TYPE.put(type, typeItem);
        }
        Placeholders.BLOCKED_GAME_TYPE.put(EnumGamemode.b, this.parse(section, "blocked.creative", Placeholders.BLOCKED_GAME_TYPE.get(EnumGamemode.b)));
        Placeholders.BLOCKED_GAME_TYPE.put(EnumGamemode.d, this.parse(section, "blocked.spectator", Placeholders.BLOCKED_GAME_TYPE.get(EnumGamemode.d)));
    }

    @NotNull
    protected ItemStack parse(@Nullable ConfigurationSection section, @NotNull String path, @NotNull ItemStack defaultStack) throws Exception {
        ItemStack itemStack;
        if (section == null) {
            return defaultStack;
        }
        String itemText = section.getString(path);
        if (itemText == null) {
            return defaultStack;
        }
        NBTTagCompound compoundTag = this.parseTag(itemText);
        DataResult parsed = ItemStack.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)compoundTag);
        try {
            itemStack = (ItemStack)parsed.getOrThrow();
        }
        catch (Exception e) {
            itemStack = null;
        }
        return itemStack == null ? defaultStack : itemStack;
    }

    @NotNull
    protected abstract NBTTagCompound parseTag(@NotNull String var1) throws Exception;

    protected abstract void addModelData(@NotNull ItemStack var1);

    protected abstract void hideTooltip(@NotNull ItemStack var1);

    protected abstract DyedItemColor getDye(int var1);

    @NotNull
    protected ItemStack defaultCraftingOutput() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.fu);
        itemStack.b(DataComponents.k, (Object)IChatBaseComponent.c((String)"container.crafting"));
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultCursor() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.xe);
        IRegistryCustom minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        IRegistry bannerPatterns = minecraftRegistry.f(Registries.aR);
        EnumBannerPatternType halfDiagBottomRight = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.v).a();
        EnumBannerPatternType downRight = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.l).a();
        EnumBannerPatternType border = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.E).a();
        itemStack.b(DataComponents.at, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.b(bannerPatterns.e((Object)halfDiagBottomRight), EnumColor.h), new BannerPatternLayers.b(bannerPatterns.e((Object)downRight), EnumColor.a), new BannerPatternLayers.b(bannerPatterns.e((Object)border), EnumColor.h))));
        this.addModelData(itemStack);
        this.hideTooltip(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultDrop() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.mN);
        itemStack.b(DataComponents.k, (Object)IChatBaseComponent.c((String)"key.drop"));
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack getEmptyArmor(@NotNull IMaterial item) {
        ItemStack itemStack = new ItemStack(item);
        DyedItemColor color = this.getDye(0xC8C8C8);
        itemStack.b(DataComponents.R, (Object)color);
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultShield() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.xH);
        itemStack.b(DataComponents.au, (Object)EnumColor.c);
        IRegistryCustom minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        IRegistry bannerPatterns = minecraftRegistry.f(Registries.aR);
        EnumBannerPatternType halfLeft = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.A).a();
        EnumBannerPatternType topLeft = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.d).a();
        EnumBannerPatternType topRight = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.e).a();
        EnumBannerPatternType bottomLeft = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.b).a();
        EnumBannerPatternType bottomRight = (EnumBannerPatternType)bannerPatterns.b(BannerPatterns.c).a();
        itemStack.b(DataComponents.at, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.b(bannerPatterns.e((Object)halfLeft), EnumColor.p), new BannerPatternLayers.b(bannerPatterns.e((Object)topLeft), EnumColor.c), new BannerPatternLayers.b(bannerPatterns.e((Object)bottomLeft), EnumColor.c), new BannerPatternLayers.b(bannerPatterns.e((Object)topRight), EnumColor.p), new BannerPatternLayers.b(bannerPatterns.e((Object)bottomRight), EnumColor.p))));
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultNotSlot() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.jm);
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultBlockedOffline() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.iu);
        itemStack.b(DataComponents.k, (Object)IChatBaseComponent.c((String)"options.narrator.notavailable").b((IChatBaseComponent)IChatBaseComponent.b((String)" - ")).b((IChatBaseComponent)IChatBaseComponent.c((String)"gui.socialInteractions.status_offline")));
        return itemStack;
    }
}

