/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.slot;

import com.lishid.openinv.internal.reobf.container.slot.Content;
import com.lishid.openinv.internal.reobf.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.reobf.container.slot.placeholder.Placeholders;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class ContentEquipment
implements Content {
    private PlayerInventory equipment;
    private final net.minecraft.world.item.ItemStack placeholder;
    private final EquipmentSlot equipmentSlot;

    public ContentEquipment(EntityPlayer holder, EnumItemSlot equipmentSlot) {
        this.setHolder(holder);
        this.placeholder = switch (equipmentSlot) {
            case EnumItemSlot.f -> Placeholders.emptyHelmet;
            case EnumItemSlot.e -> Placeholders.emptyChestplate;
            case EnumItemSlot.d -> Placeholders.emptyLeggings;
            case EnumItemSlot.c -> Placeholders.emptyBoots;
            default -> Placeholders.emptyOffHand;
        };
        this.equipmentSlot = CraftEquipmentSlot.getSlot((EnumItemSlot)equipmentSlot);
    }

    @Override
    public void setHolder(@NotNull EntityPlayer holder) {
        this.equipment = holder.getBukkitEntity().getInventory();
    }

    @Override
    public net.minecraft.world.item.ItemStack get() {
        return CraftItemStack.asNMSCopy((ItemStack)this.equipment.getItem(this.equipmentSlot));
    }

    @Override
    public net.minecraft.world.item.ItemStack remove() {
        ItemStack old = this.equipment.getItem(this.equipmentSlot);
        this.equipment.setItem(this.equipmentSlot, null);
        return CraftItemStack.asNMSCopy((ItemStack)old);
    }

    @Override
    public net.minecraft.world.item.ItemStack removePartial(int amount) {
        if (amount <= 0) {
            return net.minecraft.world.item.ItemStack.l;
        }
        net.minecraft.world.item.ItemStack current = this.get();
        if (current.f()) {
            return net.minecraft.world.item.ItemStack.l;
        }
        net.minecraft.world.item.ItemStack split = current.a(amount);
        this.set(current);
        return split;
    }

    @Override
    public void set(net.minecraft.world.item.ItemStack itemStack) {
        this.equipment.setItem(this.equipmentSlot, (ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemStack));
    }

    @Override
    public Slot asSlot(IInventory container, int slot, int x, int y) {
        return new SlotEquipment(container, slot, x, y);
    }

    @Override
    public InventoryType.SlotType getSlotType() {
        return InventoryType.SlotType.ARMOR;
    }

    public class SlotEquipment
    extends SlotPlaceholder {
        private EntityPlayer viewer;

        SlotEquipment(IInventory container, int index, int x, int y) {
            super(container, index, x, y);
        }

        @Override
        public net.minecraft.world.item.ItemStack getOrDefault() {
            net.minecraft.world.item.ItemStack itemStack = this.g();
            if (!itemStack.f()) {
                return itemStack;
            }
            return ContentEquipment.this.placeholder;
        }

        public EnumItemSlot getEquipmentSlot() {
            return CraftEquipmentSlot.getNMS((EquipmentSlot)ContentEquipment.this.equipmentSlot);
        }

        public void onlyEquipmentFor(EntityPlayer viewer) {
            this.viewer = viewer;
        }

        public boolean a(@NotNull net.minecraft.world.item.ItemStack itemStack) {
            if (this.viewer == null) {
                return true;
            }
            return ContentEquipment.this.equipmentSlot == EquipmentSlot.OFF_HAND || this.viewer.f(itemStack) == CraftEquipmentSlot.getNMS((EquipmentSlot)ContentEquipment.this.equipmentSlot);
        }
    }
}

