/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.slot;

import com.lishid.openinv.internal.reobf.container.slot.Content;
import com.lishid.openinv.internal.reobf.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.reobf.container.slot.placeholder.Placeholders;
import com.lishid.openinv.internal.reobf.player.BaseOpenPlayer;
import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class ContentCrafting
implements Content {
    private final int index;
    private EntityPlayer holder;
    private List<ItemStack> items;

    public ContentCrafting(@NotNull EntityPlayer holder, int index) {
        this.setHolder(holder);
        this.index = index;
    }

    private boolean isAvailable() {
        return ContentCrafting.isAvailable(this.holder);
    }

    public static boolean isAvailable(@NotNull EntityPlayer holder) {
        return BaseOpenPlayer.isConnected(holder.g) && holder.h.d();
    }

    @Override
    public void setHolder(@NotNull EntityPlayer holder) {
        this.holder = holder;
        this.items = holder.cm.r().getContents();
    }

    @Override
    public ItemStack get() {
        return this.isAvailable() ? this.items.get(this.index) : ItemStack.l;
    }

    @Override
    public ItemStack remove() {
        if (!this.isAvailable()) {
            return ItemStack.l;
        }
        ItemStack removed = this.items.remove(this.index);
        if (removed.f()) {
            return ItemStack.l;
        }
        this.holder.cm.a((IInventory)this.holder.cm.r());
        return removed;
    }

    @Override
    public ItemStack removePartial(int amount) {
        if (!this.isAvailable()) {
            return ItemStack.l;
        }
        ItemStack removed = ContainerUtil.a(this.items, (int)this.index, (int)amount);
        if (removed.f()) {
            return ItemStack.l;
        }
        this.holder.cm.a((IInventory)this.holder.cm.r());
        return removed;
    }

    @Override
    public void set(ItemStack itemStack) {
        if (this.isAvailable()) {
            this.items.set(this.index, itemStack);
            this.holder.cm.a((IInventory)this.holder.cm.r());
        } else {
            this.holder.a(itemStack, false);
        }
    }

    @Override
    public Slot asSlot(IInventory container, int slot, int x, int y) {
        return new SlotCrafting(container, slot, x, y);
    }

    @Override
    public InventoryType.SlotType getSlotType() {
        return this.isAvailable() ? InventoryType.SlotType.CRAFTING : InventoryType.SlotType.OUTSIDE;
    }

    public class SlotCrafting
    extends SlotPlaceholder {
        private SlotCrafting(IInventory container, int index, int x, int y) {
            super(container, index, x, y);
        }

        @Override
        public ItemStack getOrDefault() {
            return ContentCrafting.this.isAvailable() ? ContentCrafting.this.items.get(ContentCrafting.this.index) : Placeholders.survivalOnly(ContentCrafting.this.holder);
        }

        public boolean a(@NotNull EntityHuman player) {
            return ContentCrafting.this.isAvailable();
        }

        public boolean a(@NotNull ItemStack itemStack) {
            return ContentCrafting.this.isAvailable();
        }

        public boolean h() {
            return ContentCrafting.this.isAvailable() && super.h();
        }

        public boolean f() {
            return !ContentCrafting.this.isAvailable();
        }
    }
}

