/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.menu;

import com.google.common.base.Preconditions;
import com.lishid.openinv.internal.reobf.container.BaseOpenInventory;
import com.lishid.openinv.internal.reobf.container.bukkit.OpenDummyPlayerInventory;
import com.lishid.openinv.internal.reobf.container.bukkit.OpenPlayerInventorySelf;
import com.lishid.openinv.internal.reobf.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.reobf.container.menu.OpenSyncMenu;
import com.lishid.openinv.internal.reobf.container.slot.ContentDrop;
import com.lishid.openinv.internal.reobf.container.slot.ContentEquipment;
import com.lishid.openinv.internal.reobf.container.slot.SlotViewOnly;
import com.lishid.openinv.util.Permissions;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMenu
extends OpenSyncMenu<BaseOpenInventory> {
    private int offset;

    public OpenInventoryMenu(BaseOpenInventory inventory, EntityPlayer viewer, int i, boolean viewOnly) {
        super(OpenInventoryMenu.getMenuType(inventory, viewer), i, inventory, viewer, viewOnly);
    }

    private static Containers<ContainerChest> getMenuType(BaseOpenInventory inventory, EntityPlayer viewer) {
        int size = inventory.b();
        if (inventory.getOwnerHandle().equals((Object)viewer)) {
            size -= viewer.gK().j().size();
            size = (int)Math.ceil((double)size / 9.0) * 9;
        }
        return OpenInventoryMenu.getChestMenuType(size);
    }

    @Override
    protected void preSlotSetup() {
        this.offset = this.ownContainer ? this.viewer.gK().j().size() : 0;
    }

    @Override
    @NotNull
    protected Slot getUpperSlot(int index, int x, int y) {
        Slot slot = ((BaseOpenInventory)this.container).getMenuSlot(index += this.offset, x, y);
        if (slot.getClass().equals(SlotViewOnly.class)) {
            return slot;
        }
        if (slot instanceof ContentDrop.SlotDrop && (this.viewOnly || !Permissions.INVENTORY_SLOT_DROP.hasPermission((Permissible)this.viewer.getBukkitEntity()))) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (slot instanceof ContentEquipment.SlotEquipment) {
            Permissions perm;
            ContentEquipment.SlotEquipment equipment = (ContentEquipment.SlotEquipment)slot;
            if (this.viewOnly) {
                return SlotViewOnly.wrap(slot);
            }
            switch (equipment.getEquipmentSlot()) {
                case f: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_HEAD_ANY;
                    break;
                }
                case e: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_CHEST_ANY;
                    break;
                }
                case d: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_LEGS_ANY;
                    break;
                }
                case c: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_FEET_ANY;
                    break;
                }
                default: {
                    Permissions permissions = perm = null;
                }
            }
            if (perm != null && !perm.hasPermission((Permissible)this.viewer.getBukkitEntity())) {
                equipment.onlyEquipmentFor(((BaseOpenInventory)this.container).getOwnerHandle());
            }
            return slot;
        }
        if (this.ownContainer && !(slot instanceof ContentDrop.SlotDrop)) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (this.viewOnly) {
            return SlotViewOnly.wrap(slot);
        }
        return slot;
    }

    @Override
    @NotNull
    protected CraftInventoryView<OpenChestMenu<BaseOpenInventory>, Inventory> createBukkitEntity() {
        CraftInventory bukkitInventory = this.viewOnly ? new OpenDummyPlayerInventory(this.container) : (this.ownContainer ? new OpenPlayerInventorySelf((BaseOpenInventory)this.container, this.offset) : ((BaseOpenInventory)this.container).getBukkitInventory());
        return new CraftInventoryView<OpenChestMenu<BaseOpenInventory>, Inventory>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)bukkitInventory, (OpenChestMenu)this){

            public ItemStack getItem(int index) {
                if (OpenInventoryMenu.this.viewOnly || index < 0) {
                    return null;
                }
                Slot slot = (Slot)OpenInventoryMenu.this.k.get(index);
                return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)(slot.h() ? slot.g() : net.minecraft.world.item.ItemStack.l));
            }

            public boolean isInTop(int rawSlot) {
                return rawSlot < OpenInventoryMenu.this.topSize;
            }

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return null;
                }
                if (rawSlot == -999 || rawSlot == -1) {
                    return null;
                }
                Preconditions.checkArgument((rawSlot >= 0 && rawSlot < OpenInventoryMenu.this.topSize + OpenInventoryMenu.this.offset + 36 ? 1 : 0) != 0, (String)"Slot %s outside of inventory", (int)rawSlot);
                if (rawSlot > OpenInventoryMenu.this.topSize) {
                    return this.getBottomInventory();
                }
                Slot slot = (Slot)OpenInventoryMenu.this.k.get(rawSlot);
                if (slot.f()) {
                    return null;
                }
                return this.getTopInventory();
            }

            public int convertSlot(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return -999;
                }
                if (rawSlot < 0) {
                    return rawSlot;
                }
                if (rawSlot < OpenInventoryMenu.this.topSize) {
                    Slot slot = (Slot)OpenInventoryMenu.this.k.get(rawSlot);
                    if (slot.f()) {
                        return -999;
                    }
                    return rawSlot;
                }
                int slot = rawSlot - OpenInventoryMenu.this.topSize;
                slot = slot >= 27 ? (slot -= 27) : (slot += 9);
                return slot;
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenInventoryMenu.this.viewOnly || slot < 0) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                if (slot >= OpenInventoryMenu.this.topSize) {
                    if ((slot -= OpenInventoryMenu.this.topSize) >= 27) {
                        return InventoryType.SlotType.QUICKBAR;
                    }
                    return InventoryType.SlotType.CONTAINER;
                }
                return ((BaseOpenInventory)OpenInventoryMenu.this.container).getSlotType(OpenInventoryMenu.this.offset + slot);
            }

            public int countSlots() {
                return OpenInventoryMenu.this.topSize + 36;
            }
        };
    }

    @NotNull
    public net.minecraft.world.item.ItemStack b(@NotNull EntityHuman player, int index) {
        if (this.viewOnly) {
            return net.minecraft.world.item.ItemStack.l;
        }
        Slot slot = (Slot)this.k.get(index);
        if (!slot.h() || slot.f()) {
            return net.minecraft.world.item.ItemStack.l;
        }
        net.minecraft.world.item.ItemStack itemStack = slot.g();
        net.minecraft.world.item.ItemStack originalStack = itemStack.v();
        if (index < this.topSize) {
            if (!this.a(itemStack, this.topSize, this.k.size(), true)) {
                return net.minecraft.world.item.ItemStack.l;
            }
        } else {
            boolean movedGear;
            EnumItemSlot equipmentSlot = player.f(itemStack);
            block0 : switch (equipmentSlot) {
                case f: 
                case e: 
                case d: 
                case c: 
                case b: {
                    boolean bl;
                    for (int extra = ((BaseOpenInventory)this.container).getOwnerHandle().gK().j().size() - this.offset; extra < this.topSize; ++extra) {
                        ContentEquipment.SlotEquipment equipSlot;
                        Slot extraSlot = this.b(extra);
                        if (!(extraSlot instanceof ContentEquipment.SlotEquipment) || (equipSlot = (ContentEquipment.SlotEquipment)extraSlot).getEquipmentSlot() != equipmentSlot) continue;
                        bl = this.a(itemStack, extra, extra + 1, false);
                        break block0;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = movedGear = false;
                }
            }
            if (this.offset != 0 ? !movedGear : !movedGear && !this.a(itemStack, 0, ((BaseOpenInventory)this.container).getOwnerHandle().gK().j().size(), true)) {
                return net.minecraft.world.item.ItemStack.l;
            }
        }
        if (itemStack.f()) {
            slot.e(net.minecraft.world.item.ItemStack.l);
        } else {
            slot.d();
        }
        return originalStack;
    }
}

