/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.menu;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.reobf.container.bukkit.OpenDummyInventory;
import com.lishid.openinv.internal.reobf.container.slot.SlotViewOnly;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenChestMenu<T extends IInventory & ISpecialInventory>
extends Container {
    protected static final int BOTTOM_INVENTORY_SIZE = 36;
    protected final T container;
    protected final EntityPlayer viewer;
    protected final boolean viewOnly;
    protected final boolean ownContainer;
    protected final int topSize;
    private CraftInventoryView<OpenChestMenu<T>, Inventory> bukkitEntity;

    protected OpenChestMenu(@NotNull Containers<ContainerChest> type, int containerCounter, @NotNull T container, @NotNull EntityPlayer viewer, boolean viewOnly) {
        super(type, containerCounter);
        int y;
        int x;
        int col;
        this.container = container;
        this.viewer = viewer;
        this.viewOnly = viewOnly;
        this.ownContainer = ((EntityPlayer)((InternalOwned)container).getOwnerHandle()).equals((Object)viewer);
        this.topSize = this.getTopSize(viewer);
        this.preSlotSetup();
        int upperRows = this.topSize / 9;
        for (int row = 0; row < upperRows; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                y = 18 + row * 18;
                int index = row * 9 + col;
                if (index >= container.b()) {
                    this.a(new SlotViewOnly((IInventory)container, index, x, y));
                    continue;
                }
                Slot slot = this.getUpperSlot(index, x, y);
                this.a(slot);
            }
        }
        int playerInvPad = (upperRows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int x2 = 8 + col2 * 18;
                int y2 = playerInvPad + row * 18 + 103;
                this.a(new Slot((IInventory)viewer.gK(), row * 9 + col2 + 9, x2, y2));
            }
        }
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = playerInvPad + 161;
            this.a(new Slot((IInventory)viewer.gK(), col, x, y));
        }
    }

    @NotNull
    public static Containers<ContainerChest> getChestMenuType(int inventorySize) {
        inventorySize = (int)Math.ceil((double)inventorySize / 9.0) * 9;
        return switch (inventorySize) {
            case 9 -> Containers.a;
            case 18 -> Containers.b;
            case 27 -> Containers.c;
            case 36 -> Containers.d;
            case 45 -> Containers.e;
            case 54 -> Containers.f;
            default -> throw new IllegalArgumentException("Inventory size unsupported: " + inventorySize);
        };
    }

    protected void preSlotSetup() {
    }

    @NotNull
    protected Slot getUpperSlot(int index, int x, int y) {
        Slot slot = new Slot(this.container, index, x, y);
        if (this.viewOnly) {
            return SlotViewOnly.wrap(slot);
        }
        return slot;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    @NotNull
    public final CraftInventoryView<OpenChestMenu<T>, Inventory> getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = this.createBukkitEntity();
        }
        return this.bukkitEntity;
    }

    @NotNull
    protected CraftInventoryView<OpenChestMenu<T>, Inventory> createBukkitEntity() {
        Object top = this.viewOnly ? new OpenDummyInventory((IInventory)this.container, ((ISpecialInventory)this.container).getBukkitType()) : ((ISpecialInventory)this.container).getBukkitInventory();
        return new CraftInventoryView<OpenChestMenu<T>, Inventory>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)top, this){

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return null;
                }
                return super.getInventory(rawSlot);
            }

            public int convertSlot(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return -999;
                }
                return super.convertSlot(rawSlot);
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenChestMenu.this.viewOnly) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                return super.getSlotType(slot);
            }
        };
    }

    private int getTopSize(EntityPlayer viewer) {
        Containers menuType = this.a();
        if (menuType == Containers.a) {
            return 9;
        }
        if (menuType == Containers.b) {
            return 18;
        }
        if (menuType == Containers.c) {
            return 27;
        }
        if (menuType == Containers.d) {
            return 36;
        }
        if (menuType == Containers.e) {
            return 45;
        }
        if (menuType == Containers.f) {
            return 54;
        }
        return menuType.a((int)-1, (PlayerInventory)viewer.gK()).k.size() - 36;
    }

    protected boolean a(ItemStack itemStack, int rangeLow, int rangeHigh, boolean topDown) {
        int index;
        boolean modified = false;
        boolean stackable = itemStack.l();
        Slot firstEmpty = null;
        int n = index = topDown ? rangeHigh - 1 : rangeLow;
        while (!itemStack.f() && (topDown ? index >= rangeLow : index < rangeHigh)) {
            Slot slot = (Slot)this.k.get(index);
            if (!slot.f() && slot.a(itemStack)) {
                if (slot.h()) {
                    if (stackable) {
                        modified |= OpenChestMenu.addToExistingStack(itemStack, slot);
                    }
                } else {
                    if (firstEmpty == null) {
                        firstEmpty = slot;
                    }
                    if (!stackable) break;
                }
            }
            index += topDown ? -1 : 1;
        }
        if (!itemStack.f() && firstEmpty != null) {
            firstEmpty.e(itemStack.a(Math.min(itemStack.N(), firstEmpty.b_(itemStack))));
            firstEmpty.d();
            modified = true;
        }
        return modified;
    }

    private static boolean addToExistingStack(ItemStack itemStack, Slot slot) {
        ItemStack existing = slot.g();
        if (!ItemStack.c((ItemStack)itemStack, (ItemStack)existing)) {
            return false;
        }
        int max = slot.b_(existing);
        int existingCount = existing.N();
        if (existingCount >= max) {
            return false;
        }
        int total = existingCount + itemStack.N();
        if (total <= max) {
            itemStack.e(0);
            existing.e(total);
            slot.d();
            return true;
        }
        itemStack.h(max - existingCount);
        existing.e(max);
        slot.d();
        return true;
    }

    public void a(int i, int j2, @NotNull InventoryClickType clickType, @NotNull EntityHuman player) {
        if (this.viewOnly) {
            if (clickType == InventoryClickType.f) {
                this.b();
            }
            return;
        }
        super.a(i, j2, clickType, player);
    }

    public boolean b(@NotNull EntityHuman player) {
        return true;
    }
}

