/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container.bukkit;

import com.google.common.base.Preconditions;
import com.lishid.openinv.internal.reobf.container.BaseOpenInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayerInventory
extends CraftInventory
implements PlayerInventory {
    public OpenPlayerInventory(@NotNull BaseOpenInventory inventory) {
        super((IInventory)inventory);
    }

    @NotNull
    public BaseOpenInventory getInventory() {
        return (BaseOpenInventory)super.getInventory();
    }

    public ItemStack @NotNull [] getContents() {
        return this.asCraftMirror(this.getInventory().getOwnerHandle().gK().getContents());
    }

    public void setContents(ItemStack[] items) {
        net.minecraft.world.entity.player.PlayerInventory internal = this.getInventory().getOwnerHandle().gK();
        int size = internal.b();
        Preconditions.checkArgument((items.length <= size ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)size);
        for (int index = 0; index < size; ++index) {
            if (index < items.length) {
                internal.a(index, CraftItemStack.asNMSCopy((ItemStack)items[index]));
                continue;
            }
            internal.a(index, net.minecraft.world.item.ItemStack.l);
        }
    }

    public ItemStack @NotNull [] getStorageContents() {
        return this.asCraftMirror((List)this.getInventory().getOwnerHandle().gK().j());
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        NonNullList list = this.getInventory().getOwnerHandle().gK().j();
        int size = list.size();
        Preconditions.checkArgument((items.length <= size ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)size);
        for (int index = 0; index < items.length; ++index) {
            list.set(index, (Object)CraftItemStack.asNMSCopy((ItemStack)items[index]));
        }
    }

    @NotNull
    public InventoryType getType() {
        return InventoryType.PLAYER;
    }

    @NotNull
    public Player getHolder() {
        return this.getInventory().getOwner();
    }

    @NotNull
    public @NotNull ItemStack @NotNull [] getArmorContents() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getArmorContents();
    }

    public void setArmorContents(ItemStack @NotNull [] items) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setArmorContents(items);
    }

    @NotNull
    public @NotNull ItemStack @NotNull [] getExtraContents() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getExtraContents();
    }

    public void setExtraContents(ItemStack @NotNull [] items) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setExtraContents(items);
    }

    @Nullable
    public ItemStack getHelmet() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getHelmet();
    }

    public void setHelmet(@Nullable ItemStack helmet) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setHelmet(helmet);
    }

    @Nullable
    public ItemStack getChestplate() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getChestplate();
    }

    public void setChestplate(@Nullable ItemStack chestplate) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setChestplate(chestplate);
    }

    @Nullable
    public ItemStack getLeggings() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getLeggings();
    }

    public void setLeggings(@Nullable ItemStack leggings) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setLeggings(leggings);
    }

    @Nullable
    public ItemStack getBoots() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getBoots();
    }

    public void setBoots(@Nullable ItemStack boots) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setBoots(boots);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        net.minecraft.world.entity.player.PlayerInventory internal = this.getInventory().getOwnerHandle().gK();
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)internal.h());
    }

    public void setItemInMainHand(@Nullable ItemStack item) {
        net.minecraft.world.entity.player.PlayerInventory internal = this.getInventory().getOwnerHandle().gK();
        internal.b(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getItemInOffHand();
    }

    public void setItemInOffHand(@Nullable ItemStack item) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setItemInOffHand(item);
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(@Nullable ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public int getHeldItemSlot() {
        net.minecraft.world.entity.player.PlayerInventory internal = this.getInventory().getOwnerHandle().gK();
        return internal.j().size() - 9 + internal.g();
    }

    public void setHeldItemSlot(int slot) {
        this.getInventory().getOwnerHandle().gK().d(slot %= 9);
    }

    @Nullable
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        return this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().getItem(slot);
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        this.getInventory().getOwnerHandle().getBukkitEntity().getInventory().setItem(slot, item);
    }
}

