/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.reobf.container;

import com.lishid.openinv.internal.AnySilentContainerBase;
import com.lishid.openinv.internal.reobf.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.reobf.player.PlayerManager;
import com.lishid.openinv.util.ReflectionHelper;
import com.lishid.openinv.util.lang.LanguageManager;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockChestTrapped;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
extends AnySilentContainerBase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LanguageManager lang;
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.lang = lang;
        try {
            try {
                this.serverPlayerGameModeGameType = PlayerInteractManager.class.getDeclaredField("e");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.warning("The field ServerPlayerGameMode#gameModeForPlayer is no longer present!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(PlayerInteractManager.class, EnumGamemode.class);
            }
        }
        catch (SecurityException e) {
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    @Override
    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull org.bukkit.block.Block bukkitBlock) {
        BlockPosition blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        EntityPlayer player = PlayerManager.getHandle(bukkitPlayer);
        WorldServer level = player.A();
        TileEntity blockEntity = level.c_(blockPos = new BlockPosition(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof TileEntityEnderChest) {
            TileEntityEnderChest enderChestTile = (TileEntityEnderChest)blockEntity;
            InventoryEnderChest enderChest = player.gZ();
            enderChest.a(enderChestTile);
            player.a((ITileInventory)new TileInventory((containerCounter, playerInventory, ignored) -> {
                Containers<ContainerChest> containers = OpenChestMenu.getChestMenuType(enderChest.b());
                int rows = enderChest.b() / 9;
                return new ContainerChest(containers, containerCounter, playerInventory, (IInventory)enderChest, rows);
            }, (IChatBaseComponent)IChatBaseComponent.c((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof ITileInventory)) {
            return false;
        }
        ITileInventory menuProvider = (ITileInventory)blockEntity;
        IBlockData blockState = level.a_(blockPos);
        Block block = blockState.b();
        if (block instanceof BlockChest) {
            BlockChest chestBlock = (BlockChest)block;
            menuProvider = chestBlock.getMenuProvider(blockState, (World)level, blockPos, true);
            if (menuProvider == null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof BlockChestTrapped) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof BlockShulkerBox) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof BlockBarrel) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.h.b() == EnumGamemode.d) {
            player.a(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof TileEntityLootable) {
            TileEntityLootable lootable = (TileEntityLootable)blockEntity;
            if (lootable.l != null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        EnumGamemode gameType = player.h.b();
        this.forceGameType(player, EnumGamemode.d);
        player.a(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    @Override
    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        EntityPlayer player = PlayerManager.getHandle(bukkitPlayer);
        EnumGamemode gameType = player.h.b();
        this.forceGameType(player, EnumGamemode.d);
        player.cn.transferTo((Container)player.cm, (CraftHumanEntity)player.getBukkitEntity());
        player.s();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(EntityPlayer player, EnumGamemode gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.h, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.log(Level.WARNING, "Error bypassing GameModeChangeEvent", e);
        }
    }
}

