/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_8.player;

import com.lishid.openinv.internal.common.player.BaseOpenPlayer;
import com.lishid.openinv.internal.paper1_21_8.player.OpenPlayer;
import com.lishid.openinv.util.JulLoggerAdapter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PlayerManager
extends com.lishid.openinv.internal.common.player.PlayerManager {
    public PlayerManager(@NotNull java.util.logging.Logger logger) {
        super(logger);
    }

    @Override
    protected boolean loadData(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(player.problemPath(), (Logger)new JulLoggerAdapter(this.logger));){
            ValueInput loadedData = server.getPlayerList().playerIo.load((Player)player, (ProblemReporter)scopedCollector).orElse(null);
            if (loadedData == null) {
                boolean bl = false;
                return bl;
            }
            player.load(loadedData);
            player.loadGameTypes(loadedData);
            this.parseWorld(server, player, loadedData);
        }
        return true;
    }

    @Override
    protected void spawnInDefaultWorld(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            player.snapTo(player.adjustSpawnLocation(level, level.getSharedSpawnPos()).getBottomCenter(), level.getSharedSpawnAngle(), 0.0f);
            player.spawnIn(level);
        } else {
            this.logger.warning("Tried to load player with invalid world when no fallback was available!");
        }
    }

    @Override
    protected void injectPlayer(@NotNull MinecraftServer server, @NotNull ServerPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(server.server, player, this));
    }

    @Override
    @NotNull
    public org.bukkit.entity.Player inject(@NotNull org.bukkit.entity.Player player) {
        try {
            ServerPlayer nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof BaseOpenPlayer) {
                BaseOpenPlayer openPlayer = (BaseOpenPlayer)craftPlayer;
                return openPlayer;
            }
            MinecraftServer server = nmsPlayer.getServer();
            if (server == null) {
                Server server2 = Bukkit.getServer();
                if (!(server2 instanceof CraftServer)) {
                    this.logger.warning(() -> "Unable to inject ServerPlayer, certain player data may be lost when saving! Server is not a CraftServer: " + Bukkit.getServer().getClass().getName());
                    return player;
                }
                CraftServer craftServer = (CraftServer)server2;
                server = craftServer.getServer();
            }
            this.injectPlayer(server, nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(java.util.logging.Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }
}

