/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_5.player;

import com.lishid.openinv.internal.paper1_21_5.player.OpenPlayer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.dimension.DimensionType;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;

public class PlayerManager
extends com.lishid.openinv.internal.paper1_21_8.player.PlayerManager {
    public PlayerManager(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    protected boolean loadData(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        CompoundTag loadedData = server.getPlayerList().playerIo.load((Player)player).orElse(null);
        if (loadedData == null) {
            return false;
        }
        player.load(loadedData);
        player.loadGameTypes(loadedData);
        this.parseWorld(player, loadedData);
        return true;
    }

    protected void parseWorld(@NotNull ServerPlayer player, @NotNull CompoundTag loadedData) {
        World bukkitWorld;
        Optional msbs = loadedData.getLong("WorldUUIDMost");
        Optional lsbs = loadedData.getLong("WorldUUIDLeast");
        if (msbs.isPresent() && lsbs.isPresent()) {
            bukkitWorld = Bukkit.getServer().getWorld(new UUID((Long)msbs.get(), (Long)lsbs.get()));
        } else {
            Optional worldName = loadedData.getString("world");
            if (worldName.isPresent()) {
                bukkitWorld = Bukkit.getServer().getWorld((String)worldName.get());
            } else {
                DimensionType.parseLegacy((Dynamic)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)loadedData.get("Dimension"))).resultOrPartial(this.logger::warning).map(arg_0 -> ((MinecraftServer)player.server).getLevel(arg_0)).ifPresentOrElse(arg_0 -> ((ServerPlayer)player).setServerLevel(arg_0), () -> this.spawnInDefaultWorld(player.server, player));
                return;
            }
        }
        if (bukkitWorld == null) {
            this.spawnInDefaultWorld(player.server, player);
            return;
        }
        player.setServerLevel(((CraftWorld)bukkitWorld).getHandle());
    }

    @Override
    @NotNull
    public org.bukkit.entity.Player inject(@NotNull org.bukkit.entity.Player player) {
        try {
            ServerPlayer nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof OpenPlayer) {
                OpenPlayer openPlayer = (OpenPlayer)craftPlayer;
                return openPlayer;
            }
            this.injectPlayer(nmsPlayer.server, nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Override
    protected void injectPlayer(@NotNull MinecraftServer server, @NotNull ServerPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.server.server, player, this));
    }
}

