/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_5.player;

import com.lishid.openinv.internal.common.player.BaseOpenPlayer;
import com.lishid.openinv.internal.paper1_21_5.player.PlayerManager;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.bukkit.craftbukkit.CraftServer;
import org.jetbrains.annotations.NotNull;

public class OpenPlayer
extends BaseOpenPlayer {
    protected OpenPlayer(CraftServer server, ServerPlayer entity, PlayerManager manager) {
        super(server, entity, manager);
    }

    @Override
    protected void trySave(ServerPlayer player) {
        try {
            PlayerDataStorage worldNBTStorage = player.server.getPlayerList().playerIo;
            CompoundTag oldData = this.isOnline() ? null : (CompoundTag)worldNBTStorage.load(player.getName().getString(), player.getStringUUID()).orElse(null);
            CompoundTag playerData = this.getWritableTag(oldData);
            playerData = player.saveWithoutId(playerData);
            this.saveSafe(player, oldData, playerData, worldNBTStorage);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.getScoreboardName(), (Object)e);
        }
    }

    @Override
    protected void safeReplaceFile(@NotNull Path dataFile, @NotNull Path tempFile, @NotNull Path backupFile) {
        Util.safeReplaceFile((Path)dataFile, (Path)tempFile, (Path)backupFile);
    }

    @Override
    protected void remove(@NotNull CompoundTag tag, @NotNull String key) {
        tag.remove(key);
    }
}

