/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_4.player;

import com.lishid.openinv.internal.paper1_21_4.player.OpenPlayer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import java.util.logging.Logger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class PlayerManager
extends com.lishid.openinv.internal.paper1_21_5.player.PlayerManager {
    public PlayerManager(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    protected void parseWorld(@NotNull ServerPlayer player, @NotNull CompoundTag loadedData) {
        World bukkitWorld;
        if (loadedData.contains("WorldUUIDMost") && loadedData.contains("WorldUUIDLeast")) {
            bukkitWorld = Bukkit.getServer().getWorld(new UUID(loadedData.getLong("WorldUUIDMost"), loadedData.getLong("WorldUUIDLeast")));
        } else if (loadedData.contains("world", 8)) {
            bukkitWorld = Bukkit.getServer().getWorld(loadedData.getString("world"));
        } else {
            DimensionType.parseLegacy((Dynamic)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)loadedData.get("Dimension"))).resultOrPartial(this.logger::warning).map(arg_0 -> ((MinecraftServer)player.server).getLevel(arg_0)).ifPresentOrElse(arg_0 -> ((ServerPlayer)player).setServerLevel(arg_0), () -> this.spawnInDefaultWorld(player.server, player));
            return;
        }
        if (bukkitWorld == null) {
            this.spawnInDefaultWorld(player.server, player);
            return;
        }
        player.setServerLevel(((CraftWorld)bukkitWorld).getHandle());
    }

    @Override
    protected void spawnInDefaultWorld(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            player.moveTo(player.adjustSpawnLocation(level, level.getSharedSpawnPos()).getBottomCenter(), level.getSharedSpawnAngle(), 0.0f);
            player.spawnIn(level);
        } else {
            this.logger.warning("Tried to load player with invalid world when no fallback was available!");
        }
    }

    @Override
    protected void injectPlayer(@NotNull MinecraftServer server, @NotNull ServerPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.server.server, player, this));
    }
}

