/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_4.container.slot;

import com.lishid.openinv.internal.common.container.slot.ContentList;
import com.lishid.openinv.internal.common.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.common.container.slot.placeholder.Placeholders;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class ContentEquipment
extends ContentList {
    private final ItemStack placeholder;
    private final EquipmentSlot equipmentSlot;

    public ContentEquipment(ServerPlayer holder, int index, EquipmentSlot equipmentSlot) {
        super(holder, index, InventoryType.SlotType.ARMOR);
        this.placeholder = switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> Placeholders.emptyHelmet;
            case EquipmentSlot.CHEST -> Placeholders.emptyChestplate;
            case EquipmentSlot.LEGS -> Placeholders.emptyLeggings;
            case EquipmentSlot.FEET -> Placeholders.emptyBoots;
            default -> Placeholders.emptyOffHand;
        };
        this.equipmentSlot = equipmentSlot;
    }

    @Override
    public void setHolder(@NotNull ServerPlayer holder) {
        this.items = holder.getInventory().armor;
    }

    @Override
    public Slot asSlot(Container container, int slot, int x, int y) {
        return new SlotEquipment(container, slot, x, y);
    }

    public class SlotEquipment
    extends SlotPlaceholder {
        private ServerPlayer viewer;

        SlotEquipment(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        @Override
        public ItemStack getOrDefault() {
            ItemStack itemStack = this.getItem();
            if (!itemStack.isEmpty()) {
                return itemStack;
            }
            return ContentEquipment.this.placeholder;
        }

        public EquipmentSlot getEquipmentSlot() {
            return ContentEquipment.this.equipmentSlot;
        }

        public void onlyEquipmentFor(ServerPlayer viewer) {
            this.viewer = viewer;
        }

        public boolean mayPlace(@NotNull ItemStack itemStack) {
            if (this.viewer == null) {
                return true;
            }
            return ContentEquipment.this.equipmentSlot == EquipmentSlot.OFFHAND || this.viewer.getEquipmentSlotForItem(itemStack) == ContentEquipment.this.equipmentSlot;
        }
    }
}

