/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.paper1_21_4.container;

import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.container.slot.ContentCrafting;
import com.lishid.openinv.internal.common.container.slot.ContentCursor;
import com.lishid.openinv.internal.common.container.slot.ContentDrop;
import com.lishid.openinv.internal.common.container.slot.ContentList;
import com.lishid.openinv.internal.common.container.slot.ContentViewOnly;
import com.lishid.openinv.internal.common.container.slot.SlotViewOnly;
import com.lishid.openinv.internal.common.container.slot.placeholder.Placeholders;
import com.lishid.openinv.internal.paper1_21_4.container.bukkit.OpenPlayerInventory;
import com.lishid.openinv.internal.paper1_21_4.container.menu.OpenInventoryMenu;
import com.lishid.openinv.internal.paper1_21_4.container.slot.ContentEquipment;
import com.lishid.openinv.internal.paper1_21_4.container.slot.ContentOffHand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventory
extends com.lishid.openinv.internal.paper1_21_8.container.OpenInventory {
    public OpenInventory(@NotNull org.bukkit.entity.Player bukkitPlayer) {
        super(bukkitPlayer);
    }

    @Override
    protected void setupSlots() {
        int nextIndex = this.addMainInventory();
        net.minecraft.world.entity.player.Inventory ownerInv = this.owner.getInventory();
        if (ownerInv.items.size() == 36 && ownerInv.armor.size() == 4 && ownerInv.offhand.size() == 1 && this.owner.inventoryMenu.getCraftSlots().getContainerSize() == 4) {
            this.addArmor(36);
            this.addOffHand(46);
            this.slots.set(53, new ContentDrop(this.owner));
            this.slots.set(44, new ContentCursor(this.owner));
            this.addCrafting(41, true);
            return;
        }
        nextIndex = this.addArmor(nextIndex);
        nextIndex = this.addOffHand(nextIndex);
        nextIndex = this.addCrafting(nextIndex, false);
        this.slots.set(nextIndex, new ContentCursor(this.owner));
        this.slots.set(this.slots.size() - 1, new ContentDrop(this.owner));
    }

    private int addMainInventory() {
        int listSize = this.owner.getInventory().items.size();
        int hotbarDiff = listSize - 9;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            InventoryType.SlotType type;
            int invIndex;
            if (localIndex < hotbarDiff) {
                invIndex = localIndex + 9;
                type = InventoryType.SlotType.CONTAINER;
            } else {
                type = InventoryType.SlotType.QUICKBAR;
                invIndex = localIndex - hotbarDiff;
            }
            this.slots.set(localIndex, new ContentList(this, this.owner, invIndex, type){

                @Override
                public void setHolder(@NotNull ServerPlayer holder) {
                    this.items = holder.getInventory().items;
                }
            });
        }
        return listSize;
    }

    private int addArmor(int startIndex) {
        int listSize = this.owner.getInventory().armor.size();
        for (int i = 0; i < listSize; ++i) {
            int armorIndex;
            this.slots.set(startIndex + i, new ContentEquipment(this.owner, armorIndex, switch (i) {
                case 3 -> {
                    armorIndex = 0;
                    yield EquipmentSlot.FEET;
                }
                case 2 -> {
                    armorIndex = 1;
                    yield EquipmentSlot.LEGS;
                }
                case 1 -> {
                    armorIndex = 2;
                    yield EquipmentSlot.CHEST;
                }
                case 0 -> {
                    armorIndex = 3;
                    yield EquipmentSlot.HEAD;
                }
                default -> {
                    armorIndex = i;
                    yield EquipmentSlot.MAINHAND;
                }
            }));
        }
        return startIndex + listSize;
    }

    private int addOffHand(int startIndex) {
        int listSize = this.owner.getInventory().offhand.size();
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            this.slots.set(startIndex + localIndex, new ContentOffHand(this.owner, localIndex));
        }
        return startIndex + listSize;
    }

    private int addCrafting(int startIndex, boolean pretty) {
        int listSize = this.owner.inventoryMenu.getCraftSlots().getContents().size();
        pretty &= listSize == 4;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            int modIndex = startIndex + (localIndex < 2 || !pretty ? localIndex : localIndex + 7);
            this.slots.set(modIndex, new ContentCrafting(this.owner, localIndex));
        }
        if (pretty) {
            this.slots.set(startIndex + 2, new ContentViewOnly(this, this.owner){

                @Override
                public Slot asSlot(Container container, int slot, int x, int y) {
                    return new SlotViewOnly(this, container, slot, x, y){

                        @Override
                        public ItemStack getOrDefault() {
                            return Placeholders.craftingOutput;
                        }
                    };
                }
            });
            this.slots.set(startIndex + 11, this.getCraftingResult(this.owner));
        }
        return startIndex + listSize;
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new OpenPlayerInventory(this);
        }
        return this.bukkitEntity;
    }

    @Override
    @Nullable
    public OpenChestMenu<?> createMenu(Player player, int i, boolean viewOnly) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return new OpenInventoryMenu(this, serverPlayer, i, viewOnly);
        }
        return null;
    }
}

