/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.player;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.common.container.BaseOpenInventory;
import com.lishid.openinv.internal.common.container.OpenEnderChest;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.player.BaseOpenPlayer;
import com.lishid.openinv.internal.common.player.OpenPlayer;
import com.lishid.openinv.util.JulLoggerAdapter;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerManager
implements com.lishid.openinv.internal.PlayerManager {
    @NotNull
    protected final java.util.logging.Logger logger;
    @Nullable
    protected Field bukkitEntity;

    public PlayerManager(@NotNull java.util.logging.Logger logger) {
        this.logger = logger;
        try {
            this.bukkitEntity = Entity.class.getDeclaredField("bukkitEntity");
        }
        catch (NoSuchFieldException e) {
            logger.warning("Unable to obtain field to inject custom save process - certain player data may be lost when saving!");
            logger.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            this.bukkitEntity = null;
        }
    }

    @NotNull
    public static ServerPlayer getHandle(org.bukkit.entity.Player player) {
        if (player instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)player;
            return craftPlayer.getHandle();
        }
        Server server = player.getServer();
        ServerPlayer nmsPlayer = null;
        if (server instanceof CraftServer) {
            CraftServer craftServer = (CraftServer)server;
            nmsPlayer = craftServer.getHandle().getPlayer(player.getUniqueId());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from Player implementation " + player.getClass().getName());
        }
        return nmsPlayer;
    }

    @Override
    @Nullable
    public org.bukkit.entity.Player loadPlayer(@NotNull OfflinePlayer offline) {
        Server server = Bukkit.getServer();
        if (!(server instanceof CraftServer)) {
            return null;
        }
        CraftServer craftServer = (CraftServer)server;
        DedicatedServer server2 = craftServer.getServer();
        ServerLevel worldServer = server2.getLevel(Level.OVERWORLD);
        if (worldServer == null) {
            return null;
        }
        ServerPlayer entity = this.createNewPlayer((MinecraftServer)server2, worldServer, offline);
        entity.getAdvancements().stopListening();
        if (this.loadData((MinecraftServer)server2, entity)) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @NotNull
    protected ServerPlayer createNewPlayer(@NotNull MinecraftServer server, @NotNull ServerLevel worldServer, @NotNull OfflinePlayer offline) {
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        ClientInformation dummyInfo = new ClientInformation("en_us", 1, ChatVisiblity.HIDDEN, false, 0, ServerPlayer.DEFAULT_MAIN_HAND, true, false, ParticleStatus.MINIMAL);
        ServerPlayer entity = new ServerPlayer(server, worldServer, profile, dummyInfo);
        try {
            this.injectPlayer(server, entity);
        }
        catch (IllegalAccessException e) {
            this.logger.log(java.util.logging.Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
        }
        return entity;
    }

    protected boolean loadData(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(player.problemPath(), (Logger)new JulLoggerAdapter(this.logger));){
            CompoundTag loadedData = server.getPlayerList().playerIo.load(player.nameAndId()).orElse(null);
            if (loadedData == null) {
                boolean bl = false;
                return bl;
            }
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)player.registryAccess(), (CompoundTag)loadedData);
            player.load(valueInput);
            this.parseWorld(server, player, valueInput);
        }
        return true;
    }

    protected void parseWorld(@NotNull MinecraftServer server, @NotNull ServerPlayer player, @NotNull ValueInput loadedData) {
        Optional msbs = loadedData.getLong("WorldUUIDMost");
        Optional lsbs = loadedData.getLong("WorldUUIDLeast");
        World bukkitWorld = msbs.isPresent() && lsbs.isPresent() ? Bukkit.getServer().getWorld(new UUID((Long)msbs.get(), (Long)lsbs.get())) : (World)loadedData.getString("world").map(Bukkit::getWorld).orElse(null);
        if (bukkitWorld == null) {
            this.spawnInDefaultWorld(server, player);
            return;
        }
        player.setServerLevel(((CraftWorld)bukkitWorld).getHandle());
    }

    protected void spawnInDefaultWorld(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            LevelData.RespawnData respawnData = level.levelData.getRespawnData();
            player.snapTo(player.adjustSpawnLocation(level, respawnData.pos()).getBottomCenter(), respawnData.yaw(), 0.0f);
            player.spawnIn(level);
        } else {
            this.logger.warning("Tried to load player with invalid world when no fallback was available!");
        }
    }

    protected void injectPlayer(@NotNull MinecraftServer server, @NotNull ServerPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(server.server, player, this));
    }

    @Override
    @NotNull
    public org.bukkit.entity.Player inject(@NotNull org.bukkit.entity.Player player) {
        try {
            ServerPlayer nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof BaseOpenPlayer) {
                BaseOpenPlayer openPlayer = (BaseOpenPlayer)craftPlayer;
                return openPlayer;
            }
            MinecraftServer server = nmsPlayer.level().getServer();
            this.injectPlayer(server, nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(java.util.logging.Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull org.bukkit.entity.Player bukkitPlayer, @NotNull ISpecialInventory inventory, boolean viewOnly) {
        net.minecraft.network.chat.Component title;
        OpenChestMenu<?> menu;
        ServerPlayer player = PlayerManager.getHandle(bukkitPlayer);
        if (!BaseOpenPlayer.isConnected(player.connection)) {
            return null;
        }
        if (inventory instanceof BaseOpenInventory) {
            BaseOpenInventory playerInv = (BaseOpenInventory)inventory;
            menu = playerInv.createMenu((Player)player, player.nextContainerCounter(), viewOnly);
            title = playerInv.getTitle(player, menu);
        } else if (inventory instanceof OpenEnderChest) {
            OpenEnderChest enderChest = (OpenEnderChest)inventory;
            menu = enderChest.createMenu((Player)player, player.nextContainerCounter(), viewOnly);
            title = enderChest.getTitle(menu);
        } else {
            return null;
        }
        if (menu == null) {
            return null;
        }
        menu.setTitle(title);
        Pair pair = CraftEventFactory.callInventoryOpenEventWithTitle((ServerPlayer)player, menu);
        AbstractContainerMenu opened = (AbstractContainerMenu)pair.getSecond();
        if (opened == null) {
            return null;
        }
        Component newTitle = (Component)pair.getFirst();
        if (newTitle != null) {
            title = PaperAdventure.asVanilla((Component)newTitle);
        }
        player.containerMenu = opened;
        player.connection.send((Packet)new ClientboundOpenScreenPacket(opened.containerId, opened.getType(), title));
        player.initMenu(opened);
        return opened.getBukkitView();
    }
}

