/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.player;

import com.lishid.openinv.internal.common.player.BaseOpenPlayer;
import com.lishid.openinv.internal.common.player.PlayerManager;
import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.CraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class OpenPlayer
extends BaseOpenPlayer {
    protected OpenPlayer(CraftServer server, ServerPlayer entity, PlayerManager manager) {
        super(server, entity, manager);
    }

    @Override
    protected void trySave(ServerPlayer player) {
        Logger logger = LogUtils.getLogger();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(player.problemPath(), logger);){
            PlayerDataStorage worldNbtStorage = this.server.getServer().getPlayerList().playerIo;
            CompoundTag oldData = this.isOnline() ? null : (CompoundTag)worldNbtStorage.load(player.nameAndId()).orElse(null);
            CompoundTag playerData = this.getWritableTag(oldData);
            TagValueOutput valueOutput = TagValueOutput.createWrappingWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)player.registryAccess(), (CompoundTag)playerData);
            player.saveWithoutId((ValueOutput)valueOutput);
            this.saveSafe(player, oldData, playerData, worldNbtStorage);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.getScoreboardName(), (Object)e);
        }
    }

    @Override
    protected void remove(@NotNull CompoundTag tag, @NotNull String key) {
        tag.remove(key);
    }
}

