/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.player;

import com.lishid.openinv.event.OpenEvents;
import com.lishid.openinv.internal.common.player.PlayerManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Util;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class BaseOpenPlayer
extends CraftPlayer {
    protected static final @Unmodifiable Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "data", "Passengers", "warden_spawn_tracker", "entered_nether_pos", "enteredNetherPosition", "respawn", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "raid_omen_position", "ender_pearls", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "current_explosion_impact_pos", "active_effects", "sleeping_pos", "SleepingX", "SleepingY", "SleepingZ", "Brain", "last_hurt_by_player", "last_hurt_by_player_memory_time", "last_hurt_by_mob", "ticks_since_last_hurt_by_mob", "equipment", "locator_bar_icon");
    private final PlayerManager manager;

    protected BaseOpenPlayer(CraftServer server, ServerPlayer entity, PlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData((MinecraftServer)this.server.getServer(), this.getHandle());
    }

    public void saveData() {
        if (OpenEvents.saveCancelled((Player)this)) {
            return;
        }
        this.trySave(this.getHandle());
    }

    protected abstract void trySave(ServerPlayer var1);

    protected void saveSafe(@NotNull ServerPlayer player, @Nullable CompoundTag oldData, @NotNull CompoundTag playerData, @NotNull PlayerDataStorage worldNbtStorage) throws IOException {
        this.revertSpecialValues(playerData, oldData);
        Path playerDataDir = worldNbtStorage.getPlayerDir().toPath();
        Path tempFile = Files.createTempFile(playerDataDir, player.getStringUUID() + "-", ".dat", new FileAttribute[0]);
        NbtIo.writeCompressed((CompoundTag)playerData, (Path)tempFile);
        Path dataFile = playerDataDir.resolve(player.getStringUUID() + ".dat");
        Path backupFile = playerDataDir.resolve(player.getStringUUID() + ".dat_old");
        this.safeReplaceFile(dataFile, tempFile, backupFile);
    }

    protected void safeReplaceFile(@NotNull Path dataFile, @NotNull Path tempFile, @NotNull Path backupFile) {
        Util.safeReplaceFile((Path)dataFile, (Path)tempFile, (Path)backupFile);
    }

    @Contract(value="null -> new")
    @NotNull
    protected CompoundTag getWritableTag(@Nullable CompoundTag oldData) {
        if (oldData == null) {
            return new CompoundTag();
        }
        oldData = oldData.copy();
        oldData.keySet().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit") || key.startsWith("Paper") && key.length() > 5);
        return oldData;
    }

    protected void revertSpecialValues(@NotNull CompoundTag newData, @Nullable CompoundTag oldData) {
        if (oldData == null) {
            return;
        }
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", NumericTag.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", NumericTag.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", NumericTag.class);
    }

    private <T extends Tag> void copyValue(@NotNull CompoundTag source, @NotNull CompoundTag target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        CompoundTag oldContainer = this.getTag(source, container, CompoundTag.class);
        CompoundTag newContainer = this.getTag(target, container, CompoundTag.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends Tag> T getTag(@Nullable CompoundTag container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        Tag value = container.get(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((Tag)dataType.cast(value));
    }

    private <T extends Tag> void setTag(@NotNull CompoundTag container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            this.remove(container, key);
        } else {
            container.put(key, data);
        }
    }

    protected abstract void remove(@NotNull CompoundTag var1, @NotNull String var2);

    public static boolean isConnected(@Nullable ServerGamePacketListenerImpl connection) {
        return connection != null && !connection.isDisconnected();
    }
}

