/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.slot.placeholder;

import com.lishid.openinv.internal.common.container.slot.placeholder.Placeholders;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlaceholderLoaderBase {
    public void load(@Nullable ConfigurationSection section) throws Exception {
        Placeholders.craftingOutput = this.parse(section, "crafting-output", this.defaultCraftingOutput());
        Placeholders.cursor = this.parse(section, "cursor", this.defaultCursor());
        Placeholders.drop = this.parse(section, "drop", this.defaultDrop());
        Placeholders.emptyHelmet = this.parse(section, "empty-helmet", this.getEmptyArmor((ItemLike)Items.LEATHER_HELMET));
        Placeholders.emptyChestplate = this.parse(section, "empty-chestplate", this.getEmptyArmor((ItemLike)Items.LEATHER_CHESTPLATE));
        Placeholders.emptyLeggings = this.parse(section, "empty-leggings", this.getEmptyArmor((ItemLike)Items.LEATHER_LEGGINGS));
        Placeholders.emptyBoots = this.parse(section, "empty-boots", this.getEmptyArmor((ItemLike)Items.LEATHER_BOOTS));
        Placeholders.emptyOffHand = this.parse(section, "empty-off-hand", this.defaultShield());
        Placeholders.notSlot = this.parse(section, "not-a-slot", this.defaultNotSlot());
        Placeholders.blockedOffline = this.parse(section, "blocked.offline", this.defaultBlockedOffline());
        for (GameType type : GameType.values()) {
            ItemStack typeItem = new ItemStack((ItemLike)Items.BARRIER);
            typeItem.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"options.narrator.notavailable").append(" - ").append(type.getShortDisplayName()));
            Placeholders.BLOCKED_GAME_TYPE.put(type, typeItem);
        }
        Placeholders.BLOCKED_GAME_TYPE.put(GameType.CREATIVE, this.parse(section, "blocked.creative", Placeholders.BLOCKED_GAME_TYPE.get(GameType.CREATIVE)));
        Placeholders.BLOCKED_GAME_TYPE.put(GameType.SPECTATOR, this.parse(section, "blocked.spectator", Placeholders.BLOCKED_GAME_TYPE.get(GameType.SPECTATOR)));
    }

    @NotNull
    protected ItemStack parse(@Nullable ConfigurationSection section, @NotNull String path, @NotNull ItemStack defaultStack) throws Exception {
        ItemStack itemStack;
        if (section == null) {
            return defaultStack;
        }
        String itemText = section.getString(path);
        if (itemText == null) {
            return defaultStack;
        }
        CompoundTag compoundTag = this.parseTag(itemText);
        DataResult parsed = ItemStack.CODEC.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag);
        try {
            itemStack = (ItemStack)parsed.getOrThrow();
        }
        catch (Exception e) {
            itemStack = null;
        }
        return itemStack == null ? defaultStack : itemStack;
    }

    @NotNull
    protected abstract CompoundTag parseTag(@NotNull String var1) throws Exception;

    protected abstract void addModelData(@NotNull ItemStack var1);

    protected abstract void hideTooltip(@NotNull ItemStack var1);

    protected abstract DyedItemColor getDye(int var1);

    @NotNull
    protected ItemStack defaultCraftingOutput() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.CRAFTING_TABLE);
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"container.crafting"));
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultCursor() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.WHITE_BANNER);
        RegistryAccess minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        Registry bannerPatterns = minecraftRegistry.lookupOrThrow(Registries.BANNER_PATTERN);
        BannerPattern halfDiagBottomRight = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.DIAGONAL_RIGHT).value();
        BannerPattern downRight = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.STRIPE_DOWNRIGHT).value();
        BannerPattern border = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.BORDER).value();
        itemStack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)halfDiagBottomRight), DyeColor.GRAY), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)downRight), DyeColor.WHITE), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)border), DyeColor.GRAY))));
        this.addModelData(itemStack);
        this.hideTooltip(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultDrop() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.DROPPER);
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"key.drop"));
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack getEmptyArmor(@NotNull ItemLike item) {
        ItemStack itemStack = new ItemStack(item);
        DyedItemColor color = this.getDye(0xC8C8C8);
        itemStack.set(DataComponents.DYED_COLOR, (Object)color);
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultShield() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHIELD);
        itemStack.set(DataComponents.BASE_COLOR, (Object)DyeColor.MAGENTA);
        RegistryAccess minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        Registry bannerPatterns = minecraftRegistry.lookupOrThrow(Registries.BANNER_PATTERN);
        BannerPattern halfLeft = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.HALF_VERTICAL).value();
        BannerPattern topLeft = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.SQUARE_TOP_LEFT).value();
        BannerPattern topRight = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.SQUARE_TOP_RIGHT).value();
        BannerPattern bottomLeft = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.SQUARE_BOTTOM_LEFT).value();
        BannerPattern bottomRight = (BannerPattern)bannerPatterns.getOrThrow(BannerPatterns.SQUARE_BOTTOM_RIGHT).value();
        itemStack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)halfLeft), DyeColor.BLACK), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)topLeft), DyeColor.MAGENTA), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)bottomLeft), DyeColor.MAGENTA), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)topRight), DyeColor.BLACK), new BannerPatternLayers.Layer(bannerPatterns.wrapAsHolder((Object)bottomRight), DyeColor.BLACK))));
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultNotSlot() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.WHITE_STAINED_GLASS_PANE);
        this.hideTooltip(itemStack);
        this.addModelData(itemStack);
        return itemStack;
    }

    @NotNull
    protected ItemStack defaultBlockedOffline() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.BARRIER);
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"options.narrator.notavailable").append((Component)Component.literal((String)" - ")).append((Component)Component.translatable((String)"gui.socialInteractions.status_offline")));
        return itemStack;
    }
}

