/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.slot;

import com.lishid.openinv.internal.common.container.slot.Content;
import com.lishid.openinv.internal.common.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.common.container.slot.placeholder.Placeholders;
import com.lishid.openinv.internal.common.player.BaseOpenPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class ContentDrop
implements Content {
    private ServerPlayer holder;

    public ContentDrop(@NotNull ServerPlayer holder) {
        this.holder = holder;
    }

    @Override
    public void setHolder(@NotNull ServerPlayer holder) {
        this.holder = holder;
    }

    @Override
    public ItemStack get() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack remove() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack removePartial(int amount) {
        return ItemStack.EMPTY;
    }

    @Override
    public void set(ItemStack itemStack) {
        this.holder.drop(itemStack, true);
    }

    @Override
    public Slot asSlot(Container container, int slot, int x, int y) {
        return new SlotDrop(container, slot, x, y);
    }

    @Override
    public InventoryType.SlotType getSlotType() {
        return InventoryType.SlotType.OUTSIDE;
    }

    public class SlotDrop
    extends SlotPlaceholder {
        private SlotDrop(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        @Override
        public ItemStack getOrDefault() {
            return BaseOpenPlayer.isConnected(ContentDrop.this.holder.connection) ? Placeholders.drop : Placeholders.blockedOffline;
        }

        public boolean mayPlace(@NotNull ItemStack itemStack) {
            return BaseOpenPlayer.isConnected(ContentDrop.this.holder.connection);
        }

        public boolean hasItem() {
            return false;
        }

        public boolean isFake() {
            return true;
        }
    }
}

