/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.container.slot.SlotPlaceholder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.HashedStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenSyncMenu<T extends Container & ISpecialInventory>
extends OpenChestMenu<T> {
    @Nullable
    protected ContainerSynchronizer synchronizer;
    protected final List<DataSlot> dataSlots = new ArrayList<DataSlot>();
    protected final IntList remoteDataSlots = new IntArrayList();
    protected final List<ContainerListener> containerListeners = new ArrayList<ContainerListener>();
    private RemoteSlot remoteCarried = RemoteSlot.PLACEHOLDER;
    protected boolean suppressRemoteUpdates;

    protected OpenSyncMenu(@NotNull MenuType<ChestMenu> type, int containerCounter, @NotNull T container, @NotNull ServerPlayer viewer, boolean viewOnly) {
        super(type, containerCounter, container, viewer, viewOnly);
    }

    @NotNull
    protected Slot addSlot(@NotNull Slot slot) {
        slot.index = this.slots.size();
        this.slots.add((Object)slot);
        this.lastSlots.add((Object)ItemStack.EMPTY);
        this.remoteSlots.add((Object)(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER));
        return slot;
    }

    @NotNull
    protected DataSlot addDataSlot(@NotNull DataSlot dataSlot) {
        this.dataSlots.add(dataSlot);
        this.remoteDataSlots.add(0);
        return dataSlot;
    }

    protected void addDataSlots(ContainerData containerData) {
        for (int i = 0; i < containerData.getCount(); ++i) {
            this.addDataSlot(DataSlot.forContainer((ContainerData)containerData, (int)i));
        }
    }

    public void addSlotListener(@NotNull ContainerListener containerListener) {
        if (!this.containerListeners.contains(containerListener)) {
            this.containerListeners.add(containerListener);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(@NotNull ContainerSynchronizer containerSynchronizer) {
        this.synchronizer = containerSynchronizer;
        this.remoteCarried = this.synchronizer.createSlot();
        this.remoteSlots.replaceAll(slot -> this.synchronizer.createSlot());
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        int index;
        ArrayList<ItemStack> contentsCopy = new ArrayList<ItemStack>();
        for (index = 0; index < this.slots.size(); ++index) {
            ItemStack itemStack;
            Slot slot = (Slot)this.slots.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                itemStack = placeholder.getOrDefault();
            } else {
                itemStack = slot.getItem();
            }
            ItemStack itemStack2 = itemStack;
            contentsCopy.add(itemStack2);
            ((RemoteSlot)this.remoteSlots.get(index)).force(itemStack2);
        }
        this.remoteCarried.force(this.getCarried());
        for (index = 0; index < this.dataSlots.size(); ++index) {
            this.remoteDataSlots.set(index, this.dataSlots.get(index).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData((AbstractContainerMenu)this, contentsCopy, this.getCarried().copy(), this.remoteDataSlots.toIntArray());
        }
    }

    public void forceSlot(@NotNull Container container, int slot) {
        int slotsIndex = this.findSlot(container, slot).orElse(-1);
        if (slotsIndex != -1) {
            ItemStack item = ((Slot)this.slots.get(slotsIndex)).getItem();
            ((RemoteSlot)this.remoteSlots.get(slotsIndex)).force(item);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, slotsIndex, item.copy());
            }
        }
    }

    public void broadcastCarriedItem() {
        ItemStack carried = this.getCarried();
        this.remoteCarried.force(carried);
        if (this.synchronizer != null) {
            this.synchronizer.sendCarriedChange((AbstractContainerMenu)this, carried.copy());
        }
    }

    public void removeSlotListener(@NotNull ContainerListener containerListener) {
        this.containerListeners.remove(containerListener);
    }

    public void broadcastChanges() {
        int index;
        for (index = 0; index < this.slots.size(); ++index) {
            ItemStack itemStack;
            Slot slot = (Slot)this.slots.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                itemStack = placeholder.getOrDefault();
            } else {
                itemStack = slot.getItem();
            }
            ItemStack itemstack = itemStack;
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(index, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(index, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (index = 0; index < this.dataSlots.size(); ++index) {
            DataSlot dataSlot = this.dataSlots.get(index);
            int j = dataSlot.get();
            if (dataSlot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(index, j);
            }
            this.synchronizeDataSlotToRemote(index, j);
        }
    }

    public void broadcastFullState() {
        int index;
        for (index = 0; index < this.slots.size(); ++index) {
            ItemStack itemstack = ((Slot)this.slots.get(index)).getItem();
            this.triggerSlotListeners(index, itemstack, () -> ((ItemStack)itemstack).copy());
        }
        for (index = 0; index < this.dataSlots.size(); ++index) {
            DataSlot containerproperty = this.dataSlots.get(index);
            if (!containerproperty.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(index, containerproperty.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int i, int j) {
        for (ContainerListener containerListener : this.containerListeners) {
            containerListener.dataChanged((AbstractContainerMenu)this, i, j);
        }
    }

    public void triggerSlotListeners(int index, @NotNull ItemStack itemStack, @NotNull java.util.function.Supplier<ItemStack> supplier) {
        ItemStack itemStack1 = (ItemStack)this.lastSlots.get(index);
        if (!ItemStack.matches((ItemStack)itemStack1, (ItemStack)itemStack)) {
            ItemStack itemStack2 = supplier.get();
            this.lastSlots.set(index, (Object)itemStack2);
            for (ContainerListener containerListener : this.containerListeners) {
                containerListener.slotChanged((AbstractContainerMenu)this, index, itemStack2);
            }
        }
    }

    public void synchronizeSlotToRemote(int i, @NotNull ItemStack itemStack, @NotNull java.util.function.Supplier<ItemStack> supplier) {
        RemoteSlot slot;
        if (!this.suppressRemoteUpdates && !(slot = (RemoteSlot)this.remoteSlots.get(i)).matches(itemStack)) {
            slot.force(itemStack);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, i, supplier.get());
            }
        }
    }

    private void synchronizeDataSlotToRemote(int index, int value) {
        int existing;
        if (!this.suppressRemoteUpdates && (existing = this.remoteDataSlots.getInt(index)) != value) {
            this.remoteDataSlots.set(index, value);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange((AbstractContainerMenu)this, index, value);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        ItemStack carried;
        if (!this.suppressRemoteUpdates && !this.remoteCarried.matches(carried = this.getCarried())) {
            this.remoteCarried.force(carried);
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange((AbstractContainerMenu)this, carried.copy());
            }
        }
    }

    public void setRemoteCarried(@NotNull HashedStack stack) {
        this.remoteCarried.receive(stack);
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }
}

