/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.menu;

import com.google.common.base.Preconditions;
import com.lishid.openinv.internal.common.container.BaseOpenInventory;
import com.lishid.openinv.internal.common.container.bukkit.OpenDummyPlayerInventory;
import com.lishid.openinv.internal.common.container.bukkit.OpenPlayerInventorySelf;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.container.menu.OpenSyncMenu;
import com.lishid.openinv.internal.common.container.slot.ContentDrop;
import com.lishid.openinv.internal.common.container.slot.ContentEquipment;
import com.lishid.openinv.internal.common.container.slot.SlotViewOnly;
import com.lishid.openinv.util.Permissions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMenu
extends OpenSyncMenu<BaseOpenInventory> {
    private int offset;

    public OpenInventoryMenu(BaseOpenInventory inventory, ServerPlayer viewer, int i, boolean viewOnly) {
        super(OpenInventoryMenu.getMenuType(inventory, viewer), i, inventory, viewer, viewOnly);
    }

    private static MenuType<ChestMenu> getMenuType(BaseOpenInventory inventory, ServerPlayer viewer) {
        int size = inventory.getContainerSize();
        if (inventory.getOwnerHandle().equals((Object)viewer)) {
            size -= viewer.getInventory().getNonEquipmentItems().size();
            size = (int)Math.ceil((double)size / 9.0) * 9;
        }
        return OpenInventoryMenu.getChestMenuType(size);
    }

    @Override
    protected void preSlotSetup() {
        this.offset = this.ownContainer ? this.viewer.getInventory().getNonEquipmentItems().size() : 0;
    }

    @Override
    @NotNull
    protected Slot getUpperSlot(int index, int x, int y) {
        Slot slot = ((BaseOpenInventory)this.container).getMenuSlot(index += this.offset, x, y);
        if (slot.getClass().equals(SlotViewOnly.class)) {
            return slot;
        }
        if (slot instanceof ContentDrop.SlotDrop && (this.viewOnly || !Permissions.INVENTORY_SLOT_DROP.hasPermission((Permissible)this.viewer.getBukkitEntity()))) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (slot instanceof ContentEquipment.SlotEquipment) {
            Permissions perm;
            ContentEquipment.SlotEquipment equipment = (ContentEquipment.SlotEquipment)slot;
            if (this.viewOnly) {
                return SlotViewOnly.wrap(slot);
            }
            switch (equipment.getEquipmentSlot()) {
                case HEAD: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_HEAD_ANY;
                    break;
                }
                case CHEST: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_CHEST_ANY;
                    break;
                }
                case LEGS: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_LEGS_ANY;
                    break;
                }
                case FEET: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_FEET_ANY;
                    break;
                }
                default: {
                    Permissions permissions = perm = null;
                }
            }
            if (perm != null && !perm.hasPermission((Permissible)this.viewer.getBukkitEntity())) {
                equipment.onlyEquipmentFor(((BaseOpenInventory)this.container).getOwnerHandle());
            }
            return slot;
        }
        if (this.ownContainer && !(slot instanceof ContentDrop.SlotDrop)) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (this.viewOnly) {
            return SlotViewOnly.wrap(slot);
        }
        return slot;
    }

    @Override
    @NotNull
    protected CraftInventoryView<OpenChestMenu<BaseOpenInventory>, Inventory> createBukkitEntity() {
        CraftInventory bukkitInventory = this.viewOnly ? new OpenDummyPlayerInventory(this.container) : (this.ownContainer ? new OpenPlayerInventorySelf((BaseOpenInventory)this.container, this.offset) : ((BaseOpenInventory)this.container).getBukkitInventory());
        return new CraftInventoryView<OpenChestMenu<BaseOpenInventory>, Inventory>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)bukkitInventory, (OpenChestMenu)this){

            public ItemStack getItem(int index) {
                if (OpenInventoryMenu.this.viewOnly || index < 0) {
                    return null;
                }
                Slot slot = (Slot)OpenInventoryMenu.this.slots.get(index);
                return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)(slot.hasItem() ? slot.getItem() : net.minecraft.world.item.ItemStack.EMPTY));
            }

            public boolean isInTop(int rawSlot) {
                return rawSlot < OpenInventoryMenu.this.topSize;
            }

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return null;
                }
                if (rawSlot == -999 || rawSlot == -1) {
                    return null;
                }
                Preconditions.checkArgument((rawSlot >= 0 && rawSlot < OpenInventoryMenu.this.topSize + OpenInventoryMenu.this.offset + 36 ? 1 : 0) != 0, (String)"Slot %s outside of inventory", (int)rawSlot);
                if (rawSlot > OpenInventoryMenu.this.topSize) {
                    return this.getBottomInventory();
                }
                Slot slot = (Slot)OpenInventoryMenu.this.slots.get(rawSlot);
                if (slot.isFake()) {
                    return null;
                }
                return this.getTopInventory();
            }

            public int convertSlot(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return -999;
                }
                if (rawSlot < 0) {
                    return rawSlot;
                }
                if (rawSlot < OpenInventoryMenu.this.topSize) {
                    Slot slot = (Slot)OpenInventoryMenu.this.slots.get(rawSlot);
                    if (slot.isFake()) {
                        return -999;
                    }
                    return rawSlot;
                }
                int slot = rawSlot - OpenInventoryMenu.this.topSize;
                slot = slot >= 27 ? (slot -= 27) : (slot += 9);
                return slot;
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenInventoryMenu.this.viewOnly || slot < 0) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                if (slot >= OpenInventoryMenu.this.topSize) {
                    if ((slot -= OpenInventoryMenu.this.topSize) >= 27) {
                        return InventoryType.SlotType.QUICKBAR;
                    }
                    return InventoryType.SlotType.CONTAINER;
                }
                return ((BaseOpenInventory)OpenInventoryMenu.this.container).getSlotType(OpenInventoryMenu.this.offset + slot);
            }

            public int countSlots() {
                return OpenInventoryMenu.this.topSize + 36;
            }
        };
    }

    @NotNull
    public net.minecraft.world.item.ItemStack quickMoveStack(@NotNull Player player, int index) {
        if (this.viewOnly) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem() || slot.isFake()) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        net.minecraft.world.item.ItemStack itemStack = slot.getItem();
        net.minecraft.world.item.ItemStack originalStack = itemStack.copy();
        if (index < this.topSize) {
            if (!this.moveItemStackTo(itemStack, this.topSize, this.slots.size(), true)) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
        } else {
            boolean movedGear;
            EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(itemStack);
            block0 : switch (equipmentSlot) {
                case HEAD: 
                case CHEST: 
                case LEGS: 
                case FEET: 
                case OFFHAND: {
                    boolean bl;
                    for (int extra = ((BaseOpenInventory)this.container).getOwnerHandle().getInventory().getNonEquipmentItems().size() - this.offset; extra < this.topSize; ++extra) {
                        ContentEquipment.SlotEquipment equipSlot;
                        Slot extraSlot = this.getSlot(extra);
                        if (!(extraSlot instanceof ContentEquipment.SlotEquipment) || (equipSlot = (ContentEquipment.SlotEquipment)extraSlot).getEquipmentSlot() != equipmentSlot) continue;
                        bl = this.moveItemStackTo(itemStack, extra, extra + 1, false);
                        break block0;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = movedGear = false;
                }
            }
            if (this.offset != 0 ? !movedGear : !movedGear && !this.moveItemStackTo(itemStack, 0, ((BaseOpenInventory)this.container).getOwnerHandle().getInventory().getNonEquipmentItems().size(), true)) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
        }
        if (itemStack.isEmpty()) {
            slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }
}

