/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.menu;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.common.container.bukkit.OpenDummyInventory;
import com.lishid.openinv.internal.common.container.slot.SlotViewOnly;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenChestMenu<T extends Container & ISpecialInventory>
extends AbstractContainerMenu {
    protected static final int BOTTOM_INVENTORY_SIZE = 36;
    protected final T container;
    protected final ServerPlayer viewer;
    protected final boolean viewOnly;
    protected final boolean ownContainer;
    protected final int topSize;
    private CraftInventoryView<OpenChestMenu<T>, Inventory> bukkitEntity;

    protected OpenChestMenu(@NotNull MenuType<ChestMenu> type, int containerCounter, @NotNull T container, @NotNull ServerPlayer viewer, boolean viewOnly) {
        super(type, containerCounter);
        int y;
        int x;
        int col;
        this.container = container;
        this.viewer = viewer;
        this.viewOnly = viewOnly;
        this.ownContainer = ((ServerPlayer)((InternalOwned)container).getOwnerHandle()).equals((Object)viewer);
        this.topSize = this.getTopSize(viewer);
        this.preSlotSetup();
        int upperRows = this.topSize / 9;
        for (int row = 0; row < upperRows; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                y = 18 + row * 18;
                int index = row * 9 + col;
                if (index >= container.getContainerSize()) {
                    this.addSlot(new SlotViewOnly((Container)container, index, x, y));
                    continue;
                }
                Slot slot = this.getUpperSlot(index, x, y);
                this.addSlot(slot);
            }
        }
        int playerInvPad = (upperRows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int x2 = 8 + col2 * 18;
                int y2 = playerInvPad + row * 18 + 103;
                this.addSlot(new Slot((Container)viewer.getInventory(), row * 9 + col2 + 9, x2, y2));
            }
        }
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = playerInvPad + 161;
            this.addSlot(new Slot((Container)viewer.getInventory(), col, x, y));
        }
    }

    @NotNull
    public static MenuType<ChestMenu> getChestMenuType(int inventorySize) {
        inventorySize = (int)Math.ceil((double)inventorySize / 9.0) * 9;
        return switch (inventorySize) {
            case 9 -> MenuType.GENERIC_9x1;
            case 18 -> MenuType.GENERIC_9x2;
            case 27 -> MenuType.GENERIC_9x3;
            case 36 -> MenuType.GENERIC_9x4;
            case 45 -> MenuType.GENERIC_9x5;
            case 54 -> MenuType.GENERIC_9x6;
            default -> throw new IllegalArgumentException("Inventory size unsupported: " + inventorySize);
        };
    }

    protected void preSlotSetup() {
    }

    @NotNull
    protected Slot getUpperSlot(int index, int x, int y) {
        Slot slot = new Slot(this.container, index, x, y);
        if (this.viewOnly) {
            return SlotViewOnly.wrap(slot);
        }
        return slot;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    @NotNull
    public final CraftInventoryView<OpenChestMenu<T>, Inventory> getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = this.createBukkitEntity();
        }
        return this.bukkitEntity;
    }

    @NotNull
    protected CraftInventoryView<OpenChestMenu<T>, Inventory> createBukkitEntity() {
        Object top = this.viewOnly ? new OpenDummyInventory((Container)this.container, ((ISpecialInventory)this.container).getBukkitType()) : ((ISpecialInventory)this.container).getBukkitInventory();
        return new CraftInventoryView<OpenChestMenu<T>, Inventory>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)top, this){

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return null;
                }
                return super.getInventory(rawSlot);
            }

            public int convertSlot(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return -999;
                }
                return super.convertSlot(rawSlot);
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenChestMenu.this.viewOnly) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                return super.getSlotType(slot);
            }
        };
    }

    private int getTopSize(ServerPlayer viewer) {
        MenuType menuType = this.getType();
        if (menuType == MenuType.GENERIC_9x1) {
            return 9;
        }
        if (menuType == MenuType.GENERIC_9x2) {
            return 18;
        }
        if (menuType == MenuType.GENERIC_9x3) {
            return 27;
        }
        if (menuType == MenuType.GENERIC_9x4) {
            return 36;
        }
        if (menuType == MenuType.GENERIC_9x5) {
            return 45;
        }
        if (menuType == MenuType.GENERIC_9x6) {
            return 54;
        }
        return menuType.create((int)-1, (net.minecraft.world.entity.player.Inventory)viewer.getInventory()).slots.size() - 36;
    }

    protected boolean moveItemStackTo(ItemStack itemStack, int rangeLow, int rangeHigh, boolean topDown) {
        int index;
        boolean modified = false;
        boolean stackable = itemStack.isStackable();
        Slot firstEmpty = null;
        int n = index = topDown ? rangeHigh - 1 : rangeLow;
        while (!itemStack.isEmpty() && (topDown ? index >= rangeLow : index < rangeHigh)) {
            Slot slot = (Slot)this.slots.get(index);
            if (!slot.isFake() && slot.mayPlace(itemStack)) {
                if (slot.hasItem()) {
                    if (stackable) {
                        modified |= OpenChestMenu.addToExistingStack(itemStack, slot);
                    }
                } else {
                    if (firstEmpty == null) {
                        firstEmpty = slot;
                    }
                    if (!stackable) break;
                }
            }
            index += topDown ? -1 : 1;
        }
        if (!itemStack.isEmpty() && firstEmpty != null) {
            firstEmpty.setByPlayer(itemStack.split(Math.min(itemStack.getCount(), firstEmpty.getMaxStackSize(itemStack))));
            firstEmpty.setChanged();
            modified = true;
        }
        return modified;
    }

    private static boolean addToExistingStack(ItemStack itemStack, Slot slot) {
        ItemStack existing = slot.getItem();
        if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)existing)) {
            return false;
        }
        int max = slot.getMaxStackSize(existing);
        int existingCount = existing.getCount();
        if (existingCount >= max) {
            return false;
        }
        int total = existingCount + itemStack.getCount();
        if (total <= max) {
            itemStack.setCount(0);
            existing.setCount(total);
            slot.setChanged();
            return true;
        }
        itemStack.shrink(max - existingCount);
        existing.setCount(max);
        slot.setChanged();
        return true;
    }

    public void clicked(int i, int j, @NotNull ClickType clickType, @NotNull Player player) {
        if (this.viewOnly) {
            if (clickType == ClickType.QUICK_CRAFT) {
                this.sendAllDataToRemote();
            }
            return;
        }
        super.clicked(i, j, clickType, player);
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

