/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container.bukkit;

import com.google.common.base.Preconditions;
import com.lishid.openinv.internal.common.container.BaseOpenInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayerInventory
extends CraftInventory
implements PlayerInventory {
    public OpenPlayerInventory(@NotNull BaseOpenInventory inventory) {
        super((Container)inventory);
    }

    @NotNull
    public BaseOpenInventory getInventory() {
        return (BaseOpenInventory)super.getInventory();
    }

    public ItemStack @NotNull [] getContents() {
        return this.asCraftMirror(this.getInventory().getOwnerHandle().getInventory().getContents());
    }

    public void setContents(ItemStack[] items) {
        Inventory internal = this.getInventory().getOwnerHandle().getInventory();
        int size = internal.getContainerSize();
        Preconditions.checkArgument((items.length <= size ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)size);
        for (int index = 0; index < size; ++index) {
            if (index < items.length) {
                internal.setItem(index, CraftItemStack.asNMSCopy((ItemStack)items[index]));
                continue;
            }
            internal.setItem(index, net.minecraft.world.item.ItemStack.EMPTY);
        }
    }

    public ItemStack @NotNull [] getStorageContents() {
        return this.asCraftMirror((List)this.getInventory().getOwnerHandle().getInventory().getNonEquipmentItems());
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        NonNullList list = this.getInventory().getOwnerHandle().getInventory().getNonEquipmentItems();
        int size = list.size();
        Preconditions.checkArgument((items.length <= size ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)size);
        for (int index = 0; index < items.length; ++index) {
            list.set(index, (Object)CraftItemStack.asNMSCopy((ItemStack)items[index]));
        }
    }

    @NotNull
    public InventoryType getType() {
        return InventoryType.PLAYER;
    }

    @NotNull
    public Player getHolder() {
        return this.getInventory().getOwner();
    }

    @NotNull
    public @NotNull ItemStack @NotNull [] getArmorContents() {
        return this.asCraftMirror(this.getInventory().getOwnerHandle().getInventory().getArmorContents());
    }

    public void setArmorContents(ItemStack @NotNull [] items) {
        int size = Inventory.EQUIPMENT_SLOTS_SORTED_BY_INDEX.length;
        Preconditions.checkArgument((items.length <= size ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)size);
        for (int index = 0; index < items.length; ++index) {
            this.getInventory().getOwnerHandle().getInventory().equipment.set(Inventory.EQUIPMENT_SLOTS_SORTED_BY_INDEX[index], CraftItemStack.asNMSCopy((ItemStack)items[index]));
        }
    }

    @NotNull
    public @NotNull ItemStack @NotNull [] getExtraContents() {
        return this.asCraftMirror(List.of(this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.OFFHAND)));
    }

    public void setExtraContents(ItemStack @NotNull [] items) {
        Preconditions.checkArgument((items.length <= 1 ? 1 : 0) != 0, (Object)"items.length must be <= 1");
        for (ItemStack item : items) {
            this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.OFFHAND, CraftItemStack.asNMSCopy((ItemStack)item));
        }
    }

    @NotNull
    public ItemStack getHelmet() {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.HEAD));
    }

    public void setHelmet(@Nullable ItemStack helmet) {
        this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.HEAD, CraftItemStack.asNMSCopy((ItemStack)helmet));
    }

    @NotNull
    public ItemStack getChestplate() {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.CHEST));
    }

    public void setChestplate(@Nullable ItemStack chestplate) {
        this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.CHEST, CraftItemStack.asNMSCopy((ItemStack)chestplate));
    }

    @NotNull
    public ItemStack getLeggings() {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.LEGS));
    }

    public void setLeggings(@Nullable ItemStack leggings) {
        this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.LEGS, CraftItemStack.asNMSCopy((ItemStack)leggings));
    }

    @NotNull
    public ItemStack getBoots() {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.FEET));
    }

    public void setBoots(@Nullable ItemStack boots) {
        this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.FEET, CraftItemStack.asNMSCopy((ItemStack)boots));
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        Inventory internal = this.getInventory().getOwnerHandle().getInventory();
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)internal.getSelectedItem());
    }

    public void setItemInMainHand(@Nullable ItemStack item) {
        Inventory internal = this.getInventory().getOwnerHandle().getInventory();
        internal.setSelectedItem(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)this.getInventory().getOwnerHandle().getInventory().equipment.get(EquipmentSlot.OFFHAND));
    }

    public void setItemInOffHand(@Nullable ItemStack item) {
        this.getInventory().getOwnerHandle().getInventory().equipment.set(EquipmentSlot.OFFHAND, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(@Nullable ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public int getHeldItemSlot() {
        Inventory internal = this.getInventory().getOwnerHandle().getInventory();
        return internal.getNonEquipmentItems().size() - 9 + internal.getSelectedSlot();
    }

    public void setHeldItemSlot(int slot) {
        this.getInventory().getOwnerHandle().getInventory().setSelectedSlot(slot %= 9);
    }

    @NotNull
    public ItemStack getItem(@NotNull org.bukkit.inventory.EquipmentSlot slot) {
        return switch (slot) {
            case org.bukkit.inventory.EquipmentSlot.HAND -> this.getItemInMainHand();
            case org.bukkit.inventory.EquipmentSlot.OFF_HAND -> this.getItemInOffHand();
            case org.bukkit.inventory.EquipmentSlot.FEET -> this.getBoots();
            case org.bukkit.inventory.EquipmentSlot.LEGS -> this.getLeggings();
            case org.bukkit.inventory.EquipmentSlot.CHEST -> this.getChestplate();
            case org.bukkit.inventory.EquipmentSlot.HEAD -> this.getHelmet();
            default -> throw new IllegalArgumentException("Unsupported EquipmentSlot " + String.valueOf(slot));
        };
    }

    public void setItem(@NotNull org.bukkit.inventory.EquipmentSlot slot, @Nullable ItemStack item) {
        switch (slot) {
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported EquipmentSlot " + String.valueOf(slot));
            }
        }
    }
}

