/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container;

import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.container.menu.OpenEnderChestMenu;
import com.lishid.openinv.internal.common.player.PlayerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenEnderChest
implements Container,
StackedContentsCompatible,
InternalOwned<ServerPlayer>,
ISpecialEnderChest {
    private CraftInventory inventory;
    @NotNull
    private ServerPlayer owner;
    private NonNullList<ItemStack> items;
    private int maxStack = 64;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    public OpenEnderChest(@NotNull org.bukkit.entity.Player player) {
        this.owner = PlayerManager.getHandle(player);
        this.items = this.owner.getEnderChestInventory().items;
    }

    @Override
    @NotNull
    public ServerPlayer getOwnerHandle() {
        return this.owner;
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        if (this.inventory == null) {
            this.inventory = new CraftInventory(this, this){

                @NotNull
                public InventoryType getType() {
                    return InventoryType.ENDER_CHEST;
                }
            };
        }
        return this.inventory;
    }

    @Override
    public void setPlayerOnline(@NotNull org.bukkit.entity.Player player) {
        this.owner = PlayerManager.getHandle(player);
        NonNullList activeItems = this.owner.getEnderChestInventory().items;
        int max = Math.min(this.items.size(), activeItems.size());
        for (int index = 0; index < max; ++index) {
            activeItems.set(index, (Object)((ItemStack)this.items.get(index)));
        }
        this.items = activeItems;
    }

    @NotNull
    public org.bukkit.entity.Player getPlayer() {
        return this.owner.getBukkitEntity();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int index, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.set(index, (Object)ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public void setItem(int index, @NotNull ItemStack itemStack) {
        if (index >= 0 && index < this.items.size()) {
            this.items.set(index, (Object)itemStack);
        }
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void setChanged() {
        this.owner.getEnderChestInventory().setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @NotNull
    public List<ItemStack> getContents() {
        return this.items;
    }

    public void onOpen(@NotNull CraftHumanEntity craftHumanEntity) {
        this.transaction.add((HumanEntity)craftHumanEntity);
    }

    public void onClose(@NotNull CraftHumanEntity craftHumanEntity) {
        this.transaction.remove(craftHumanEntity);
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public org.bukkit.entity.Player getOwner() {
        return this.getPlayer();
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Nullable
    public Location getLocation() {
        return null;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void fillStackedContents(@NotNull StackedItemContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.accountStack(itemstack);
        }
    }

    public Component getTitle(@Nullable OpenChestMenu<?> menu) {
        MutableComponent component = menu != null && menu.isViewOnly() ? Component.translatableWithFallback((String)"openinv.container.enderchest.viewonly", (String)"[RO] ") : Component.translatableWithFallback((String)"openinv.container.enderchest.editable", (String)"");
        return component.append((Component)Component.translatableWithFallback((String)"openinv.container.enderchest.prefix", (String)"", (Object[])new Object[]{this.owner.getName()})).append((Component)Component.translatable((String)"container.enderchest")).append((Component)Component.translatableWithFallback((String)"openinv.container.enderchest.suffix", (String)" - %s", (Object[])new Object[]{this.owner.getName()}));
    }

    @Nullable
    public OpenChestMenu<?> createMenu(Player player, int i, boolean viewOnly) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return new OpenEnderChestMenu(this, serverPlayer, i, viewOnly);
        }
        return null;
    }
}

