/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container;

import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.common.container.bukkit.OpenPlayerInventory;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.container.menu.OpenInventoryMenu;
import com.lishid.openinv.internal.common.container.slot.Content;
import com.lishid.openinv.internal.common.container.slot.ContentCrafting;
import com.lishid.openinv.internal.common.container.slot.ContentCraftingResult;
import com.lishid.openinv.internal.common.container.slot.ContentCursor;
import com.lishid.openinv.internal.common.container.slot.ContentDrop;
import com.lishid.openinv.internal.common.container.slot.ContentEquipment;
import com.lishid.openinv.internal.common.container.slot.ContentList;
import com.lishid.openinv.internal.common.container.slot.ContentOffHand;
import com.lishid.openinv.internal.common.container.slot.ContentViewOnly;
import com.lishid.openinv.internal.common.container.slot.SlotViewOnly;
import com.lishid.openinv.internal.common.container.slot.placeholder.Placeholders;
import com.lishid.openinv.internal.common.player.PlayerManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOpenInventory
implements Container,
InternalOwned<ServerPlayer>,
ISpecialPlayerInventory {
    protected final List<Content> slots;
    private final int size;
    protected ServerPlayer owner;
    private int maxStackSize = 99;
    protected CraftInventory bukkitEntity;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    public BaseOpenInventory(@NotNull org.bukkit.entity.Player bukkitPlayer) {
        this.owner = PlayerManager.getHandle(bukkitPlayer);
        int rawSize = this.owner.getInventory().getContainerSize() + this.owner.inventoryMenu.getCraftSlots().getContainerSize() + 1;
        this.size = (int)Math.ceil((double)rawSize / 9.0) * 9;
        this.slots = NonNullList.withSize((int)this.size, (Object)new ContentViewOnly(this.owner));
        this.setupSlots();
    }

    protected void setupSlots() {
        int nextIndex = this.addMainInventory();
        net.minecraft.world.entity.player.Inventory ownerInv = this.owner.getInventory();
        if (ownerInv.getNonEquipmentItems().size() == 36 && this.owner.inventoryMenu.getCraftSlots().getContainerSize() == 4 && (net.minecraft.world.entity.player.Inventory.EQUIPMENT_SLOT_MAPPING.size() == 5 || net.minecraft.world.entity.player.Inventory.EQUIPMENT_SLOT_MAPPING.size() == 7)) {
            this.addArmor(36);
            this.addOffHand(46);
            this.slots.set(53, new ContentDrop(this.owner));
            this.slots.set(44, new ContentCursor(this.owner));
            this.addCrafting(41, true);
            return;
        }
        nextIndex = this.addArmor(nextIndex);
        nextIndex = this.addOffHand(nextIndex);
        nextIndex = this.addCrafting(nextIndex, false);
        this.slots.set(nextIndex, new ContentCursor(this.owner));
        this.slots.set(this.slots.size() - 1, new ContentDrop(this.owner));
    }

    private int addMainInventory() {
        int listSize = this.owner.getInventory().getNonEquipmentItems().size();
        int hotbarDiff = listSize - 9;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            InventoryType.SlotType type;
            int invIndex;
            if (localIndex < hotbarDiff) {
                invIndex = localIndex + 9;
                type = InventoryType.SlotType.CONTAINER;
            } else {
                type = InventoryType.SlotType.QUICKBAR;
                invIndex = localIndex - hotbarDiff;
            }
            this.slots.set(localIndex, new ContentList(this, this.owner, invIndex, type){

                @Override
                public void setHolder(@NotNull ServerPlayer holder) {
                    this.items = holder.getInventory().getNonEquipmentItems();
                }
            });
        }
        return listSize;
    }

    private int addArmor(int startIndex) {
        EquipmentSlot[] sorted = (EquipmentSlot[])net.minecraft.world.entity.player.Inventory.EQUIPMENT_SLOT_MAPPING.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).toArray(EquipmentSlot[]::new);
        int localIndex = 0;
        for (int i = sorted.length - 1; i >= 0; --i) {
            if (sorted[i].getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.slots.set(startIndex + localIndex, new ContentEquipment(this.owner, sorted[i]));
            ++localIndex;
        }
        return startIndex + localIndex;
    }

    private int addOffHand(int startIndex) {
        if (!net.minecraft.world.entity.player.Inventory.EQUIPMENT_SLOT_MAPPING.containsValue((Object)EquipmentSlot.OFFHAND)) {
            return startIndex;
        }
        this.slots.set(startIndex, new ContentOffHand(this.owner));
        return startIndex + 1;
    }

    private int addCrafting(int startIndex, boolean pretty) {
        int listSize = this.owner.inventoryMenu.getCraftSlots().getContents().size();
        pretty &= listSize == 4;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            int modIndex = startIndex + (localIndex < 2 || !pretty ? localIndex : localIndex + 7);
            this.slots.set(modIndex, new ContentCrafting(this.owner, localIndex));
        }
        if (pretty) {
            this.slots.set(startIndex + 2, new ContentViewOnly(this, this.owner){

                @Override
                public Slot asSlot(Container container, int slot, int x, int y) {
                    return new SlotViewOnly(this, container, slot, x, y){

                        @Override
                        public ItemStack getOrDefault() {
                            return Placeholders.craftingOutput;
                        }
                    };
                }
            });
            this.slots.set(startIndex + 11, this.getCraftingResult(this.owner));
        }
        return startIndex + listSize;
    }

    protected Content getCraftingResult(@NotNull ServerPlayer serverPlayer) {
        return new ContentCraftingResult(serverPlayer);
    }

    public Slot getMenuSlot(int index, int x, int y) {
        return this.slots.get(index).asSlot(this, index, x, y);
    }

    public InventoryType.SlotType getSlotType(int index) {
        return this.slots.get(index).getSlotType();
    }

    public abstract Component getTitle(ServerPlayer var1, @Nullable OpenChestMenu<?> var2);

    @Override
    public ServerPlayer getOwnerHandle() {
        return this.owner;
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new OpenPlayerInventory(this);
        }
        return this.bukkitEntity;
    }

    @Override
    public void setPlayerOnline(@NotNull org.bukkit.entity.Player player) {
        ServerPlayer newOwner = PlayerManager.getHandle(player);
        newOwner.getInventory().replaceWith(this.owner.getInventory());
        this.owner = newOwner;
        this.slots.forEach(slot -> slot.setHolder(newOwner));
    }

    @Override
    public boolean isInUse() {
        return !this.transaction.isEmpty();
    }

    @NotNull
    public org.bukkit.entity.Player getPlayer() {
        return this.getOwner();
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.slots.stream().map(Content::get).allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int index) {
        return this.slots.get(index).get();
    }

    @NotNull
    public ItemStack removeItem(int index, int amount) {
        return this.slots.get(index).removePartial(amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return this.slots.get(index).remove();
    }

    public void setItem(int index, @NotNull ItemStack itemStack) {
        this.slots.get(index).set(itemStack);
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @NotNull
    public List<ItemStack> getContents() {
        NonNullList contents = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            contents.set(i, (Object)this.getItem(i));
        }
        return contents;
    }

    public void onOpen(@NotNull CraftHumanEntity viewer) {
        this.transaction.add((HumanEntity)viewer);
    }

    public void onClose(@NotNull CraftHumanEntity viewer) {
        this.transaction.remove(viewer);
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @NotNull
    public org.bukkit.entity.Player getOwner() {
        return this.owner.getBukkitEntity();
    }

    public Location getLocation() {
        return this.owner.getBukkitEntity().getLocation();
    }

    public void clearContent() {
        this.owner.getInventory().clearContent();
        this.owner.inventoryMenu.getCraftSlots().clearContent();
        this.owner.inventoryMenu.slotsChanged((Container)this.owner.inventoryMenu.getCraftSlots());
        this.owner.containerMenu.setCarried(ItemStack.EMPTY);
    }

    @Nullable
    public OpenChestMenu<?> createMenu(Player player, int i, boolean viewOnly) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return new OpenInventoryMenu(this, serverPlayer, i, viewOnly);
        }
        return null;
    }
}

