/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.common.container;

import com.lishid.openinv.internal.AnySilentContainerBase;
import com.lishid.openinv.internal.common.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.common.player.PlayerManager;
import com.lishid.openinv.util.ReflectionHelper;
import com.lishid.openinv.util.lang.LanguageManager;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
extends AnySilentContainerBase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LanguageManager lang;
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.lang = lang;
        try {
            try {
                this.serverPlayerGameModeGameType = ServerPlayerGameMode.class.getDeclaredField("gameModeForPlayer");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.warning("The field ServerPlayerGameMode#gameModeForPlayer is no longer present!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(ServerPlayerGameMode.class, GameType.class);
            }
        }
        catch (SecurityException e) {
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(java.util.logging.Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    @Override
    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull org.bukkit.block.Block bukkitBlock) {
        BlockPos blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        ServerPlayer player = PlayerManager.getHandle(bukkitPlayer);
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(blockPos = new BlockPos(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof EnderChestBlockEntity) {
            EnderChestBlockEntity enderChestTile = (EnderChestBlockEntity)blockEntity;
            PlayerEnderChestContainer enderChest = player.getEnderChestInventory();
            enderChest.setActiveChest(enderChestTile);
            player.openMenu((MenuProvider)new SimpleMenuProvider((containerCounter, playerInventory, ignored) -> {
                MenuType<ChestMenu> containers = OpenChestMenu.getChestMenuType(enderChest.getContainerSize());
                int rows = enderChest.getContainerSize() / 9;
                return new ChestMenu(containers, containerCounter, playerInventory, (Container)enderChest, rows);
            }, (Component)Component.translatable((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof MenuProvider)) {
            return false;
        }
        MenuProvider menuProvider = (MenuProvider)blockEntity;
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            menuProvider = chestBlock.getMenuProvider(blockState, level, blockPos, true);
            if (menuProvider == null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof TrappedChestBlock) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof ShulkerBoxBlock) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof BarrelBlock) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            player.openMenu(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootable = (RandomizableContainerBlockEntity)blockEntity;
            if (lootable.lootTable != null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        GameType gameType = player.gameMode.getGameModeForPlayer();
        this.forceGameType(player, GameType.SPECTATOR);
        player.openMenu(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    @Override
    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ServerPlayer player = PlayerManager.getHandle(bukkitPlayer);
        GameType gameType = player.gameMode.getGameModeForPlayer();
        this.forceGameType(player, GameType.SPECTATOR);
        player.containerMenu.transferTo((AbstractContainerMenu)player.inventoryMenu, (CraftHumanEntity)player.getBukkitEntity());
        player.doCloseContainer();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(ServerPlayer player, GameType gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.gameMode, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.log(java.util.logging.Level.WARNING, "Error bypassing GameModeChangeEvent", e);
        }
    }
}

