/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal;

import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.EnderChest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public interface IAnySilentContainer {
    public boolean activateContainer(@NotNull Player var1, boolean var2, @NotNull Block var3);

    public void deactivateContainer(@NotNull Player var1);

    public boolean isAnyContainerNeeded(@NotNull Block var1);

    default public boolean isShulkerBlocked(@NotNull Block shulkerBox) {
        Directional directional = (Directional)shulkerBox.getBlockData();
        BlockFace facing = directional.getFacing();
        BoundingBox box = new BoundingBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        box.expand(facing, 0.5);
        box.shift(facing.getOppositeFace().getDirection());
        return shulkerBox.getRelative(facing).getCollisionShape().overlaps(box);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isChestBlocked(@NotNull Block chest) {
        Block relative = chest.getRelative(0, 1, 0);
        if (relative.getType().isOccluding()) return true;
        if (chest.getWorld().getNearbyEntities(BoundingBox.of((Block)relative), Cat.class::isInstance).isEmpty()) return false;
        return true;
    }

    public boolean isAnySilentContainer(@NotNull Block var1);

    default public boolean isAnySilentContainer(@NotNull BlockState blockState) {
        InventoryHolder holder;
        return blockState instanceof InventoryHolder && this.isAnySilentContainer(holder = (InventoryHolder)blockState) || blockState instanceof EnderChest;
    }

    default public boolean isAnySilentContainer(@NotNull InventoryHolder holder) {
        return holder instanceof EnderChest || holder instanceof Chest || holder instanceof DoubleChest || holder instanceof ShulkerBox || holder instanceof Barrel;
    }
}

