/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.command;

import com.lishid.openinv.util.SearchHelper;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEnchantCommand
implements TabExecutor {
    @NotNull
    private final LanguageManager lang;

    public SearchEnchantCommand(@NotNull LanguageManager lang) {
        this.lang = lang;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        Enchantment enchant = null;
        int level = 0;
        for (String argument : args) {
            try {
                level = Integer.parseInt(argument);
            }
            catch (NumberFormatException numberFormatException) {
                Enchantment localEnchant;
                argument = argument.toLowerCase(Locale.ENGLISH);
                NamespacedKey key = NamespacedKey.fromString((String)argument);
                if (key == null || (localEnchant = (Enchantment)Registry.ENCHANTMENT.get(key)) == null) continue;
                enchant = localEnchant;
            }
        }
        if (level == 0 && enchant == null) {
            return false;
        }
        StringBuilder players = new StringBuilder();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            boolean flagInventory = this.containsEnchantment((Inventory)player.getInventory(), enchant, level);
            boolean flagEnder = this.containsEnchantment(player.getEnderChest(), enchant, level);
            if (!flagInventory && !flagEnder) continue;
            players.append(player.getName()).append(" (");
            if (flagInventory) {
                players.append("inv");
            }
            if (flagEnder) {
                if (flagInventory) {
                    players.append(',');
                }
                players.append("ender");
            }
            players.append("), ");
        }
        if (players.isEmpty()) {
            this.lang.sendMessage(sender, "messages.info.player.noMatches", new Replacement("%target%", (enchant != null ? enchant.getKey().toString() : "") + " >= " + level));
            return true;
        }
        players.delete(players.length() - 2, players.length());
        this.lang.sendMessage(sender, "messages.info.player.matches", new Replacement("%target%", (enchant != null ? enchant.getKey().toString() : "") + " >= " + level), new Replacement("%detail%", players.toString()));
        return true;
    }

    private boolean containsEnchantment(Inventory inventory, @Nullable Enchantment enchant, int minLevel) {
        return SearchHelper.findMatch(inventory, itemStack -> {
            if (!itemStack.hasItemMeta()) {
                return false;
            }
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null || !meta.hasEnchants()) {
                return false;
            }
            if (enchant != null) {
                return meta.getEnchantLevel(enchant) >= minLevel;
            }
            Iterator iterator = meta.getEnchants().values().iterator();
            while (iterator.hasNext()) {
                int enchLevel = (Integer)iterator.next();
                if (enchLevel < minLevel) continue;
                return true;
            }
            return false;
        });
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length < 1 || args.length > 2) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return TabCompleter.completeObject(args[0], enchantment -> enchantment.getKey().toString(), (Enchantment[])Registry.ENCHANTMENT.stream().toArray(Enchantment[]::new));
        }
        return TabCompleter.completeInteger(args[1]);
    }
}

