/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.command;

import com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.runnable.WrappedRunnable;
import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.AccessEqualMode;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.PlayerLoader;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.config.Config;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerLookupCommand
implements TabExecutor {
    @NotNull
    protected final OpenInv plugin;
    @NotNull
    protected final LanguageManager lang;
    @NotNull
    protected final Config config;
    @NotNull
    protected final PlayerLoader playerLoader;

    public PlayerLookupCommand(@NotNull OpenInv plugin, @NotNull LanguageManager lang, @NotNull Config config, @NotNull PlayerLoader playerLoader) {
        this.plugin = plugin;
        this.lang = lang;
        this.config = config;
        this.playerLoader = playerLoader;
    }

    public boolean onCommand(final @NotNull CommandSender sender, @NotNull Command command, @NotNull String label, final @NotNull @NotNull String @NotNull [] args) {
        boolean accessInv;
        final String targetId = this.getTargetIdentifer(sender, command, args.length > 0 ? args[0] : null, accessInv = this.isAccessInventory(command));
        if (targetId == null) {
            return true;
        }
        new WrappedRunnable(){

            @Override
            public void run() {
                final OfflinePlayer target = PlayerLookupCommand.this.getTarget(targetId);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    PlayerLookupCommand.this.lang.sendMessage(sender, "messages.error.invalidPlayer");
                    return;
                }
                new WrappedRunnable(){

                    @Override
                    public void run() {
                        Player player;
                        if (sender instanceof Player && !(player = (Player)sender).isValid()) {
                            return;
                        }
                        PlayerAccess onlineTarget = PlayerLookupCommand.this.access(sender, target, accessInv);
                        if (onlineTarget != null) {
                            PlayerLookupCommand.this.handle(sender, onlineTarget, accessInv, args);
                        }
                    }
                }.runTask(PlayerLookupCommand.this.plugin);
            }
        }.runTaskAsynchronously(this.plugin);
        return true;
    }

    protected abstract boolean isAccessInventory(@NotNull Command var1);

    @Nullable
    protected abstract String getTargetIdentifer(@NotNull CommandSender var1, @NotNull Command var2, @Nullable String var3, boolean var4);

    @Nullable
    protected abstract OfflinePlayer getTarget(@NotNull String var1);

    @Nullable
    protected PlayerAccess access(@NotNull CommandSender sender, @NotNull OfflinePlayer target, boolean invPerms) {
        Player onlineTarget = this.accessAsPlayer(sender, target);
        if (onlineTarget == null) {
            return null;
        }
        if (this.deniedCommand(sender, onlineTarget, invPerms)) {
            return null;
        }
        return this.accessGeneralized(sender, onlineTarget, invPerms);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected Player accessAsPlayer(@NotNull CommandSender sender, @NotNull OfflinePlayer target) {
        Player onlineTarget;
        block5: {
            if (!target.isOnline()) {
                if (!this.config.isOfflineDisabled() && Permissions.ACCESS_OFFLINE.hasPermission((Permissible)sender)) {
                    onlineTarget = this.playerLoader.load(target);
                    break block5;
                } else {
                    this.lang.sendMessage(sender, "messages.error.permissionPlayerOffline");
                    return null;
                }
            }
            if (!Permissions.ACCESS_ONLINE.hasPermission((Permissible)sender)) {
                this.lang.sendMessage(sender, "messages.error.permissionPlayerOnline");
                return null;
            }
            onlineTarget = target.getPlayer();
        }
        if (onlineTarget == null) {
            this.lang.sendMessage(sender, "messages.error.invalidPlayer");
            return null;
        }
        return onlineTarget;
    }

    protected abstract boolean deniedCommand(@NotNull CommandSender var1, @NotNull Player var2, boolean var3);

    @Nullable
    protected PlayerAccess accessGeneralized(@NotNull CommandSender sender, @NotNull Player onlineTarget, boolean invPerms) {
        boolean viewOnly;
        boolean ownContainer = sender.equals((Object)onlineTarget);
        Permissions edit = invPerms ? (ownContainer ? Permissions.INVENTORY_EDIT_SELF : Permissions.INVENTORY_EDIT_OTHER) : (ownContainer ? Permissions.ENDERCHEST_EDIT_SELF : Permissions.ENDERCHEST_EDIT_OTHER);
        boolean bl = viewOnly = !edit.hasPermission((Permissible)sender);
        if (ownContainer) {
            return new PlayerAccess(onlineTarget, viewOnly);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!Permissions.ACCESS_CROSSWORLD.hasPermission((Permissible)sender) && !onlineTarget.getWorld().equals((Object)player.getWorld())) {
                this.lang.sendMessage(sender, "messages.error.permissionCrossWorld", new Replacement("%target%", onlineTarget.getDisplayName()));
                return null;
            }
        }
        AccessEqualMode accessMode = AccessEqualMode.getByPerm((Permissible)sender, this.config);
        for (int level = 4; level > 0; --level) {
            String permission = "openinv.access.level." + level;
            if (!onlineTarget.hasPermission(permission)) {
                if (!sender.hasPermission(permission)) continue;
                break;
            }
            if (!sender.hasPermission(permission) || accessMode == AccessEqualMode.DENY) {
                this.lang.sendMessage(sender, "messages.error.permissionExempt", new Replacement("%target%", onlineTarget.getDisplayName()));
                return null;
            }
            if (accessMode != AccessEqualMode.VIEW) break;
            viewOnly = true;
            break;
        }
        return new PlayerAccess(onlineTarget, viewOnly);
    }

    protected abstract void handle(@NotNull CommandSender var1, @NotNull PlayerAccess var2, boolean var3, @NotNull @NotNull String @NotNull [] var4);

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length != 1) {
            return Collections.emptyList();
        }
        return TabCompleter.completeOnlinePlayer(sender, args[0]);
    }

    protected record PlayerAccess(Player player, boolean viewOnly) {
    }
}

