/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.command;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.command.PlayerLookupCommand;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.util.InventoryManager;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.PlayerLoader;
import com.lishid.openinv.util.config.Config;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClearInvCommand
extends PlayerLookupCommand {
    @NotNull
    private final InventoryManager manager;

    public ClearInvCommand(@NotNull OpenInv plugin, @NotNull Config config, @NotNull InventoryManager manager, @NotNull LanguageManager lang, @NotNull PlayerLoader playerLoader) {
        super(plugin, lang, config, playerLoader);
        this.manager = manager;
    }

    @Override
    protected boolean isAccessInventory(@NotNull Command command) {
        return command.getName().equals("clearinv");
    }

    @Override
    @Nullable
    protected String getTargetIdentifer(@NotNull CommandSender sender, @NotNull Command command, @Nullable String argument, boolean accessInv) {
        if (!Permissions.CLEAR_OTHER.hasPermission((Permissible)sender)) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return player.getUniqueId().toString();
            }
            this.lang.sendMessage(sender, "messages.error.permissionOpenOther");
            return null;
        }
        if (argument != null) {
            return argument;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return player.getUniqueId().toString();
        }
        sender.sendMessage(command.getUsage());
        return null;
    }

    @Override
    @Nullable
    protected OfflinePlayer getTarget(@NotNull String identifier) {
        return this.playerLoader.matchExact(identifier);
    }

    @Override
    protected boolean deniedCommand(@NotNull CommandSender sender, @NotNull Player onlineTarget, boolean accessInv) {
        if (onlineTarget.equals((Object)sender)) {
            return !Permissions.CLEAR_SELF.hasPermission((Permissible)sender);
        }
        return !Permissions.CLEAR_OTHER.hasPermission((Permissible)sender);
    }

    @Override
    protected void handle(@NotNull CommandSender sender, @NotNull PlayerLookupCommand.PlayerAccess playerAccess, boolean accessInv, @NotNull @NotNull String @NotNull [] args) {
        ISpecialInventory inv;
        Player onlineTarget = playerAccess.player();
        try {
            inv = accessInv ? this.manager.getInventory(onlineTarget) : this.manager.getEnderChest(onlineTarget);
        }
        catch (Exception e) {
            this.lang.sendMessage(sender, "messages.error.commandException");
            this.plugin.getLogger().log(Level.WARNING, "Unable to create ISpecialInventory", e);
            return;
        }
        inv.getBukkitInventory().clear();
        this.manager.save(onlineTarget.getUniqueId());
        this.lang.sendMessage(sender, accessInv ? "messages.info.clear.inventory" : "messages.info.clear.enderchest", new Replacement("%target%", onlineTarget.getDisplayName()));
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Permissions.CLEAR_OTHER.hasPermission((Permissible)sender)) {
            return List.of();
        }
        return super.onTabComplete(sender, command, label, args);
    }
}

