/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.lib.planarwrappers.util.version;

import com.github.jikoo.openinv.lib.planarwrappers.util.version.IntVersion;
import com.github.jikoo.openinv.lib.planarwrappers.util.version.StringVersion;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Version
extends Comparable<Version> {
    default public boolean lessThan(@NotNull Version other) {
        return this.compareTo(other) < 0;
    }

    default public boolean lessThanOrEqual(@NotNull Version other) {
        return this.compareTo(other) <= 0;
    }

    default public boolean greaterThan(@NotNull Version other) {
        return this.compareTo(other) > 0;
    }

    default public boolean greaterThanOrEqual(@NotNull Version other) {
        return this.compareTo(other) >= 0;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Version of(int ... data) {
        return new IntVersion(data);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Version of(@NotNull String data) {
        if (Pattern.compile("^(\\d+\\.)*+\\d+$").matcher(data).matches()) {
            String[] raw = data.split("\\.");
            int[] parsed = new int[raw.length];
            for (int index = 0; index < raw.length; ++index) {
                parsed[index] = Integer.parseInt(raw[index]);
            }
            return new IntVersion(parsed);
        }
        return new StringVersion(data);
    }
}

